package org.simantics.structural.stubs;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class StructuralResource2 {
    
    public final Resource AbstractDefinedComponentType;
    public final Resource AllowsConnectionType;
    public final Resource AllowsConnectionType_Inverse;
    public final Resource BelongsTo;
    public final Resource BelongsToInverse;
    public final Resource Binds;
    public final Resource CardinalityRestriction;
    public final Resource Component;
    public final Resource ComponentGroup;
    public final Resource ComponentType;
    public final Resource ComponentTypeScript;
    public final Resource ComponentTypeScript_code;
    public final Resource ComponentTypeScript_code_Inverse;
    public final Resource ComponentTypeScript_type;
    public final Resource ComponentTypeScript_type_Inverse;
    public final Resource ComponentType_HasDefaultMonitorValueType;
    public final Resource ComponentType_HasDefaultPropertyRelationType;
    public final Resource ComponentType_HasDefaultPropertyValueType;
    public final Resource ComponentType_Locked;
    public final Resource ComponentType_hasScript;
    public final Resource ComponentType_hasScript_Inverse;
    public final Resource Composite;
    public final Resource Composite_instantiationFunction;
    public final Resource Composite_instantiationFunction_Inverse;
    public final Resource Composite_namingFunction;
    public final Resource Composite_namingFunction_Inverse;
    public final Resource Connection;
    public final Resource ConnectionConstraint;
    public final Resource ConnectionDirection;
    public final Resource ConnectionJoin;
    public final Resource ConnectionRelation;
    public final Resource ConnectionRelationType;
    public final Resource ConnectionRelation_connectionRequired;
    public final Resource ConnectionRelation_connectionRequired_Inverse;
    public final Resource ConnectionRelation_equivalentConnectionPoint;
    public final Resource ConnectionType;
    public final Resource ConnectionType_isUserSelectable;
    public final Resource ConnectionType_isUserSelectable_Inverse;
    public final Resource ConnectionValidationConstraint;
    public final Resource ConnectionValidationConstraint_ErrorIssue;
    public final Resource ConnectionValidationConstraint_Source;
    public final Resource Connects;
    public final Resource DefaultConnectionType;
    public final Resource DefaultModelingRules;
    public final Resource DefaultsToConnectionType;
    public final Resource DefaultsToConnectionType_Inverse;
    public final Resource DefinedComponentType;
    public final Resource Defines;
    public final Resource Functions;
    public final Resource Functions_computeExpression;
    public final Resource Functions_connectionExtension;
    public final Resource Functions_connectionIssueDescription;
    public final Resource Functions_connectionValidator;
    public final Resource Functions_connectionValueAccessor;
    public final Resource Functions_expressionValueAccessor;
    public final Resource Functions_structuralChildDomainChildren;
    public final Resource Functions_structuralChildDomainProperties;
    public final Resource Functions_structuralRunDomainChildren;
    public final Resource GroupBelongsTo;
    public final Resource GroupBelongsToInverse;
    public final Resource GroupSubsumption;
    public final Resource HasAttachmentRelation;
    public final Resource HasCardinalityRestriction;
    public final Resource HasConnectionConstraint;
    public final Resource HasConnectionDirection;
    public final Resource HasConnectionJoin;
    public final Resource HasConnectionType;
    public final Resource HasExpression;
    public final Resource HasExpression_Inverse;
    public final Resource HasJoinClusterSet;
    public final Resource HasJoinClusterSet_Inverse;
    public final Resource HasLowerBound;
    public final Resource HasLowerBound_Inverse;
    public final Resource HasModelingRules;
    public final Resource HasSubgroup;
    public final Resource HasTypeOverride;
    public final Resource HasUpperBound;
    public final Resource HasUpperBound_Inverse;
    public final Resource InComposite;
    public final Resource InComposite_Inverse;
    public final Resource InputDirection;
    public final Resource InvalidSCLExpressionIssue;
    public final Resource IsBoundBy;
    public final Resource IsConnectedTo;
    public final Resource IsDefinedBy;
    public final Resource IsIncludedInConnectionType;
    public final Resource IsIncludedInConnectionType_Inverse;
    public final Resource IsJoinedBy;
    public final Resource Joins;
    public final Resource JoinsComposite;
    public final Resource ModelingRules;
    public final Resource MonitorValue;
    public final Resource MonitorValueType;
    public final Resource OrderedComposite;
    public final Resource OutputDirection;
    public final Resource OverridesConnectionType;
    public final Resource OverridesConnectionType_Inverse;
    public final Resource ProceduralComponentType;
    public final Resource ProceduralComponentTypeCode;
    public final Resource ProceduralComponentType_code;
    public final Resource ProceduralComponentType_code_Inverse;
    public final Resource ProceduralComponentType_environment;
    public final Resource Property;
    public final Resource ProvidingConnectionRelation;
    public final Resource ReplaceableDefinedComponentType;
    public final Resource Run;
    public final Resource SCLValue;
    public final Resource SimpleModelingRules;
    public final Resource StandardModelingRules;
    public final Resource SupportsConnectionType;
    public final Resource SupportsDirection;
    public final Resource SynchronizedConnectionRelation;
    public final Resource SynchronizedRelation;
    public final Resource TypeOverride;
    public final Resource TypeOverride_HasOriginalType;
    public final Resource TypeOverride_HasReplacementType;
    public final Resource UserDefinedProperty;
    public final Resource input;
    public final Resource input_Inverse;
    public final Resource scl;
    public final Resource sclValue;
    public final Resource structuralRevision;
    public final Resource structuralRevision_Inverse;
    public final Resource synchronizedRevision;
    public final Resource synchronizedRevision_Inverse;
        
    public static class URIs {
        public static final String AbstractDefinedComponentType = "http://www.simantics.org/Structural-1.2/AbstractDefinedComponentType";
        public static final String AllowsConnectionType = "http://www.simantics.org/Structural-1.2/AllowsConnectionType";
        public static final String AllowsConnectionType_Inverse = "http://www.simantics.org/Structural-1.2/AllowsConnectionType/Inverse";
        public static final String BelongsTo = "http://www.simantics.org/Structural-1.2/BelongsTo";
        public static final String BelongsToInverse = "http://www.simantics.org/Structural-1.2/BelongsToInverse";
        public static final String Binds = "http://www.simantics.org/Structural-1.2/Binds";
        public static final String CardinalityRestriction = "http://www.simantics.org/Structural-1.2/CardinalityRestriction";
        public static final String Component = "http://www.simantics.org/Structural-1.2/Component";
        public static final String ComponentGroup = "http://www.simantics.org/Structural-1.2/ComponentGroup";
        public static final String ComponentType = "http://www.simantics.org/Structural-1.2/ComponentType";
        public static final String ComponentTypeScript = "http://www.simantics.org/Structural-1.2/ComponentTypeScript";
        public static final String ComponentTypeScript_code = "http://www.simantics.org/Structural-1.2/ComponentTypeScript/code";
        public static final String ComponentTypeScript_code_Inverse = "http://www.simantics.org/Structural-1.2/ComponentTypeScript/code/Inverse";
        public static final String ComponentTypeScript_type = "http://www.simantics.org/Structural-1.2/ComponentTypeScript/type";
        public static final String ComponentTypeScript_type_Inverse = "http://www.simantics.org/Structural-1.2/ComponentTypeScript/type/Inverse";
        public static final String ComponentType_HasDefaultMonitorValueType = "http://www.simantics.org/Structural-1.2/ComponentType/HasDefaultMonitorValueType";
        public static final String ComponentType_HasDefaultPropertyRelationType = "http://www.simantics.org/Structural-1.2/ComponentType/HasDefaultPropertyRelationType";
        public static final String ComponentType_HasDefaultPropertyValueType = "http://www.simantics.org/Structural-1.2/ComponentType/HasDefaultPropertyValueType";
        public static final String ComponentType_Locked = "http://www.simantics.org/Structural-1.2/ComponentType/Locked";
        public static final String ComponentType_hasScript = "http://www.simantics.org/Structural-1.2/ComponentType/hasScript";
        public static final String ComponentType_hasScript_Inverse = "http://www.simantics.org/Structural-1.2/ComponentType/hasScript/Inverse";
        public static final String Composite = "http://www.simantics.org/Structural-1.2/Composite";
        public static final String Composite_instantiationFunction = "http://www.simantics.org/Structural-1.2/Composite/instantiationFunction";
        public static final String Composite_instantiationFunction_Inverse = "http://www.simantics.org/Structural-1.2/Composite/instantiationFunction/Inverse";
        public static final String Composite_namingFunction = "http://www.simantics.org/Structural-1.2/Composite/namingFunction";
        public static final String Composite_namingFunction_Inverse = "http://www.simantics.org/Structural-1.2/Composite/namingFunction/Inverse";
        public static final String Connection = "http://www.simantics.org/Structural-1.2/Connection";
        public static final String ConnectionConstraint = "http://www.simantics.org/Structural-1.2/ConnectionConstraint";
        public static final String ConnectionDirection = "http://www.simantics.org/Structural-1.2/ConnectionDirection";
        public static final String ConnectionJoin = "http://www.simantics.org/Structural-1.2/ConnectionJoin";
        public static final String ConnectionRelation = "http://www.simantics.org/Structural-1.2/ConnectionRelation";
        public static final String ConnectionRelationType = "http://www.simantics.org/Structural-1.2/ConnectionRelationType";
        public static final String ConnectionRelation_connectionRequired = "http://www.simantics.org/Structural-1.2/ConnectionRelation/connectionRequired";
        public static final String ConnectionRelation_connectionRequired_Inverse = "http://www.simantics.org/Structural-1.2/ConnectionRelation/connectionRequired/Inverse";
        public static final String ConnectionRelation_equivalentConnectionPoint = "http://www.simantics.org/Structural-1.2/ConnectionRelation/equivalentConnectionPoint";
        public static final String ConnectionType = "http://www.simantics.org/Structural-1.2/ConnectionType";
        public static final String ConnectionType_isUserSelectable = "http://www.simantics.org/Structural-1.2/ConnectionType/isUserSelectable";
        public static final String ConnectionType_isUserSelectable_Inverse = "http://www.simantics.org/Structural-1.2/ConnectionType/isUserSelectable/Inverse";
        public static final String ConnectionValidationConstraint = "http://www.simantics.org/Structural-1.2/ConnectionValidationConstraint";
        public static final String ConnectionValidationConstraint_ErrorIssue = "http://www.simantics.org/Structural-1.2/ConnectionValidationConstraint/ErrorIssue";
        public static final String ConnectionValidationConstraint_Source = "http://www.simantics.org/Structural-1.2/ConnectionValidationConstraint/Source";
        public static final String Connects = "http://www.simantics.org/Structural-1.2/Connects";
        public static final String DefaultConnectionType = "http://www.simantics.org/Structural-1.2/DefaultConnectionType";
        public static final String DefaultModelingRules = "http://www.simantics.org/Structural-1.2/DefaultModelingRules";
        public static final String DefaultsToConnectionType = "http://www.simantics.org/Structural-1.2/DefaultsToConnectionType";
        public static final String DefaultsToConnectionType_Inverse = "http://www.simantics.org/Structural-1.2/DefaultsToConnectionType/Inverse";
        public static final String DefinedComponentType = "http://www.simantics.org/Structural-1.2/DefinedComponentType";
        public static final String Defines = "http://www.simantics.org/Structural-1.2/Defines";
        public static final String Functions = "http://www.simantics.org/Structural-1.2/Functions";
        public static final String Functions_computeExpression = "http://www.simantics.org/Structural-1.2/Functions/computeExpression";
        public static final String Functions_connectionExtension = "http://www.simantics.org/Structural-1.2/Functions/connectionExtension";
        public static final String Functions_connectionIssueDescription = "http://www.simantics.org/Structural-1.2/Functions/connectionIssueDescription";
        public static final String Functions_connectionValidator = "http://www.simantics.org/Structural-1.2/Functions/connectionValidator";
        public static final String Functions_connectionValueAccessor = "http://www.simantics.org/Structural-1.2/Functions/connectionValueAccessor";
        public static final String Functions_expressionValueAccessor = "http://www.simantics.org/Structural-1.2/Functions/expressionValueAccessor";
        public static final String Functions_structuralChildDomainChildren = "http://www.simantics.org/Structural-1.2/Functions/structuralChildDomainChildren";
        public static final String Functions_structuralChildDomainProperties = "http://www.simantics.org/Structural-1.2/Functions/structuralChildDomainProperties";
        public static final String Functions_structuralRunDomainChildren = "http://www.simantics.org/Structural-1.2/Functions/structuralRunDomainChildren";
        public static final String GroupBelongsTo = "http://www.simantics.org/Structural-1.2/GroupBelongsTo";
        public static final String GroupBelongsToInverse = "http://www.simantics.org/Structural-1.2/GroupBelongsToInverse";
        public static final String GroupSubsumption = "http://www.simantics.org/Structural-1.2/GroupSubsumption";
        public static final String HasAttachmentRelation = "http://www.simantics.org/Structural-1.2/HasAttachmentRelation";
        public static final String HasCardinalityRestriction = "http://www.simantics.org/Structural-1.2/HasCardinalityRestriction";
        public static final String HasConnectionConstraint = "http://www.simantics.org/Structural-1.2/HasConnectionConstraint";
        public static final String HasConnectionDirection = "http://www.simantics.org/Structural-1.2/HasConnectionDirection";
        public static final String HasConnectionJoin = "http://www.simantics.org/Structural-1.2/HasConnectionJoin";
        public static final String HasConnectionType = "http://www.simantics.org/Structural-1.2/HasConnectionType";
        public static final String HasExpression = "http://www.simantics.org/Structural-1.2/HasExpression";
        public static final String HasExpression_Inverse = "http://www.simantics.org/Structural-1.2/HasExpression/Inverse";
        public static final String HasJoinClusterSet = "http://www.simantics.org/Structural-1.2/HasJoinClusterSet";
        public static final String HasJoinClusterSet_Inverse = "http://www.simantics.org/Structural-1.2/HasJoinClusterSet/Inverse";
        public static final String HasLowerBound = "http://www.simantics.org/Structural-1.2/HasLowerBound";
        public static final String HasLowerBound_Inverse = "http://www.simantics.org/Structural-1.2/HasLowerBound/Inverse";
        public static final String HasModelingRules = "http://www.simantics.org/Structural-1.2/HasModelingRules";
        public static final String HasSubgroup = "http://www.simantics.org/Structural-1.2/HasSubgroup";
        public static final String HasTypeOverride = "http://www.simantics.org/Structural-1.2/HasTypeOverride";
        public static final String HasUpperBound = "http://www.simantics.org/Structural-1.2/HasUpperBound";
        public static final String HasUpperBound_Inverse = "http://www.simantics.org/Structural-1.2/HasUpperBound/Inverse";
        public static final String InComposite = "http://www.simantics.org/Structural-1.2/InComposite";
        public static final String InComposite_Inverse = "http://www.simantics.org/Structural-1.2/InComposite/Inverse";
        public static final String InputDirection = "http://www.simantics.org/Structural-1.2/InputDirection";
        public static final String InvalidSCLExpressionIssue = "http://www.simantics.org/Structural-1.2/InvalidSCLExpressionIssue";
        public static final String IsBoundBy = "http://www.simantics.org/Structural-1.2/IsBoundBy";
        public static final String IsConnectedTo = "http://www.simantics.org/Structural-1.2/IsConnectedTo";
        public static final String IsDefinedBy = "http://www.simantics.org/Structural-1.2/IsDefinedBy";
        public static final String IsIncludedInConnectionType = "http://www.simantics.org/Structural-1.2/IsIncludedInConnectionType";
        public static final String IsIncludedInConnectionType_Inverse = "http://www.simantics.org/Structural-1.2/IsIncludedInConnectionType/Inverse";
        public static final String IsJoinedBy = "http://www.simantics.org/Structural-1.2/IsJoinedBy";
        public static final String Joins = "http://www.simantics.org/Structural-1.2/Joins";
        public static final String JoinsComposite = "http://www.simantics.org/Structural-1.2/JoinsComposite";
        public static final String ModelingRules = "http://www.simantics.org/Structural-1.2/ModelingRules";
        public static final String MonitorValue = "http://www.simantics.org/Structural-1.2/MonitorValue";
        public static final String MonitorValueType = "http://www.simantics.org/Structural-1.2/MonitorValueType";
        public static final String OrderedComposite = "http://www.simantics.org/Structural-1.2/OrderedComposite";
        public static final String OutputDirection = "http://www.simantics.org/Structural-1.2/OutputDirection";
        public static final String OverridesConnectionType = "http://www.simantics.org/Structural-1.2/OverridesConnectionType";
        public static final String OverridesConnectionType_Inverse = "http://www.simantics.org/Structural-1.2/OverridesConnectionType/Inverse";
        public static final String ProceduralComponentType = "http://www.simantics.org/Structural-1.2/ProceduralComponentType";
        public static final String ProceduralComponentTypeCode = "http://www.simantics.org/Structural-1.2/ProceduralComponentTypeCode";
        public static final String ProceduralComponentType_code = "http://www.simantics.org/Structural-1.2/ProceduralComponentType/code";
        public static final String ProceduralComponentType_code_Inverse = "http://www.simantics.org/Structural-1.2/ProceduralComponentType/code/Inverse";
        public static final String ProceduralComponentType_environment = "http://www.simantics.org/Structural-1.2/ProceduralComponentType/environment";
        public static final String Property = "http://www.simantics.org/Structural-1.2/Property";
        public static final String ProvidingConnectionRelation = "http://www.simantics.org/Structural-1.2/ProvidingConnectionRelation";
        public static final String ReplaceableDefinedComponentType = "http://www.simantics.org/Structural-1.2/ReplaceableDefinedComponentType";
        public static final String Run = "http://www.simantics.org/Structural-1.2/Run";
        public static final String SCLValue = "http://www.simantics.org/Structural-1.2/SCLValue";
        public static final String SimpleModelingRules = "http://www.simantics.org/Structural-1.2/SimpleModelingRules";
        public static final String StandardModelingRules = "http://www.simantics.org/Structural-1.2/StandardModelingRules";
        public static final String SupportsConnectionType = "http://www.simantics.org/Structural-1.2/SupportsConnectionType";
        public static final String SupportsDirection = "http://www.simantics.org/Structural-1.2/SupportsDirection";
        public static final String SynchronizedConnectionRelation = "http://www.simantics.org/Structural-1.2/SynchronizedConnectionRelation";
        public static final String SynchronizedRelation = "http://www.simantics.org/Structural-1.2/SynchronizedRelation";
        public static final String TypeOverride = "http://www.simantics.org/Structural-1.2/TypeOverride";
        public static final String TypeOverride_HasOriginalType = "http://www.simantics.org/Structural-1.2/TypeOverride/HasOriginalType";
        public static final String TypeOverride_HasReplacementType = "http://www.simantics.org/Structural-1.2/TypeOverride/HasReplacementType";
        public static final String UserDefinedProperty = "http://www.simantics.org/Structural-1.2/UserDefinedProperty";
        public static final String input = "http://www.simantics.org/Structural-1.2/input";
        public static final String input_Inverse = "http://www.simantics.org/Structural-1.2/input/Inverse";
        public static final String scl = "http://www.simantics.org/Structural-1.2/scl";
        public static final String sclValue = "http://www.simantics.org/Structural-1.2/sclValue";
        public static final String structuralRevision = "http://www.simantics.org/Structural-1.2/structuralRevision";
        public static final String structuralRevision_Inverse = "http://www.simantics.org/Structural-1.2/structuralRevision/Inverse";
        public static final String synchronizedRevision = "http://www.simantics.org/Structural-1.2/synchronizedRevision";
        public static final String synchronizedRevision_Inverse = "http://www.simantics.org/Structural-1.2/synchronizedRevision/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public StructuralResource2(ReadGraph graph) {
        AbstractDefinedComponentType = getResourceOrNull(graph, URIs.AbstractDefinedComponentType);
        AllowsConnectionType = getResourceOrNull(graph, URIs.AllowsConnectionType);
        AllowsConnectionType_Inverse = getResourceOrNull(graph, URIs.AllowsConnectionType_Inverse);
        BelongsTo = getResourceOrNull(graph, URIs.BelongsTo);
        BelongsToInverse = getResourceOrNull(graph, URIs.BelongsToInverse);
        Binds = getResourceOrNull(graph, URIs.Binds);
        CardinalityRestriction = getResourceOrNull(graph, URIs.CardinalityRestriction);
        Component = getResourceOrNull(graph, URIs.Component);
        ComponentGroup = getResourceOrNull(graph, URIs.ComponentGroup);
        ComponentType = getResourceOrNull(graph, URIs.ComponentType);
        ComponentTypeScript = getResourceOrNull(graph, URIs.ComponentTypeScript);
        ComponentTypeScript_code = getResourceOrNull(graph, URIs.ComponentTypeScript_code);
        ComponentTypeScript_code_Inverse = getResourceOrNull(graph, URIs.ComponentTypeScript_code_Inverse);
        ComponentTypeScript_type = getResourceOrNull(graph, URIs.ComponentTypeScript_type);
        ComponentTypeScript_type_Inverse = getResourceOrNull(graph, URIs.ComponentTypeScript_type_Inverse);
        ComponentType_HasDefaultMonitorValueType = getResourceOrNull(graph, URIs.ComponentType_HasDefaultMonitorValueType);
        ComponentType_HasDefaultPropertyRelationType = getResourceOrNull(graph, URIs.ComponentType_HasDefaultPropertyRelationType);
        ComponentType_HasDefaultPropertyValueType = getResourceOrNull(graph, URIs.ComponentType_HasDefaultPropertyValueType);
        ComponentType_Locked = getResourceOrNull(graph, URIs.ComponentType_Locked);
        ComponentType_hasScript = getResourceOrNull(graph, URIs.ComponentType_hasScript);
        ComponentType_hasScript_Inverse = getResourceOrNull(graph, URIs.ComponentType_hasScript_Inverse);
        Composite = getResourceOrNull(graph, URIs.Composite);
        Composite_instantiationFunction = getResourceOrNull(graph, URIs.Composite_instantiationFunction);
        Composite_instantiationFunction_Inverse = getResourceOrNull(graph, URIs.Composite_instantiationFunction_Inverse);
        Composite_namingFunction = getResourceOrNull(graph, URIs.Composite_namingFunction);
        Composite_namingFunction_Inverse = getResourceOrNull(graph, URIs.Composite_namingFunction_Inverse);
        Connection = getResourceOrNull(graph, URIs.Connection);
        ConnectionConstraint = getResourceOrNull(graph, URIs.ConnectionConstraint);
        ConnectionDirection = getResourceOrNull(graph, URIs.ConnectionDirection);
        ConnectionJoin = getResourceOrNull(graph, URIs.ConnectionJoin);
        ConnectionRelation = getResourceOrNull(graph, URIs.ConnectionRelation);
        ConnectionRelationType = getResourceOrNull(graph, URIs.ConnectionRelationType);
        ConnectionRelation_connectionRequired = getResourceOrNull(graph, URIs.ConnectionRelation_connectionRequired);
        ConnectionRelation_connectionRequired_Inverse = getResourceOrNull(graph, URIs.ConnectionRelation_connectionRequired_Inverse);
        ConnectionRelation_equivalentConnectionPoint = getResourceOrNull(graph, URIs.ConnectionRelation_equivalentConnectionPoint);
        ConnectionType = getResourceOrNull(graph, URIs.ConnectionType);
        ConnectionType_isUserSelectable = getResourceOrNull(graph, URIs.ConnectionType_isUserSelectable);
        ConnectionType_isUserSelectable_Inverse = getResourceOrNull(graph, URIs.ConnectionType_isUserSelectable_Inverse);
        ConnectionValidationConstraint = getResourceOrNull(graph, URIs.ConnectionValidationConstraint);
        ConnectionValidationConstraint_ErrorIssue = getResourceOrNull(graph, URIs.ConnectionValidationConstraint_ErrorIssue);
        ConnectionValidationConstraint_Source = getResourceOrNull(graph, URIs.ConnectionValidationConstraint_Source);
        Connects = getResourceOrNull(graph, URIs.Connects);
        DefaultConnectionType = getResourceOrNull(graph, URIs.DefaultConnectionType);
        DefaultModelingRules = getResourceOrNull(graph, URIs.DefaultModelingRules);
        DefaultsToConnectionType = getResourceOrNull(graph, URIs.DefaultsToConnectionType);
        DefaultsToConnectionType_Inverse = getResourceOrNull(graph, URIs.DefaultsToConnectionType_Inverse);
        DefinedComponentType = getResourceOrNull(graph, URIs.DefinedComponentType);
        Defines = getResourceOrNull(graph, URIs.Defines);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_computeExpression = getResourceOrNull(graph, URIs.Functions_computeExpression);
        Functions_connectionExtension = getResourceOrNull(graph, URIs.Functions_connectionExtension);
        Functions_connectionIssueDescription = getResourceOrNull(graph, URIs.Functions_connectionIssueDescription);
        Functions_connectionValidator = getResourceOrNull(graph, URIs.Functions_connectionValidator);
        Functions_connectionValueAccessor = getResourceOrNull(graph, URIs.Functions_connectionValueAccessor);
        Functions_expressionValueAccessor = getResourceOrNull(graph, URIs.Functions_expressionValueAccessor);
        Functions_structuralChildDomainChildren = getResourceOrNull(graph, URIs.Functions_structuralChildDomainChildren);
        Functions_structuralChildDomainProperties = getResourceOrNull(graph, URIs.Functions_structuralChildDomainProperties);
        Functions_structuralRunDomainChildren = getResourceOrNull(graph, URIs.Functions_structuralRunDomainChildren);
        GroupBelongsTo = getResourceOrNull(graph, URIs.GroupBelongsTo);
        GroupBelongsToInverse = getResourceOrNull(graph, URIs.GroupBelongsToInverse);
        GroupSubsumption = getResourceOrNull(graph, URIs.GroupSubsumption);
        HasAttachmentRelation = getResourceOrNull(graph, URIs.HasAttachmentRelation);
        HasCardinalityRestriction = getResourceOrNull(graph, URIs.HasCardinalityRestriction);
        HasConnectionConstraint = getResourceOrNull(graph, URIs.HasConnectionConstraint);
        HasConnectionDirection = getResourceOrNull(graph, URIs.HasConnectionDirection);
        HasConnectionJoin = getResourceOrNull(graph, URIs.HasConnectionJoin);
        HasConnectionType = getResourceOrNull(graph, URIs.HasConnectionType);
        HasExpression = getResourceOrNull(graph, URIs.HasExpression);
        HasExpression_Inverse = getResourceOrNull(graph, URIs.HasExpression_Inverse);
        HasJoinClusterSet = getResourceOrNull(graph, URIs.HasJoinClusterSet);
        HasJoinClusterSet_Inverse = getResourceOrNull(graph, URIs.HasJoinClusterSet_Inverse);
        HasLowerBound = getResourceOrNull(graph, URIs.HasLowerBound);
        HasLowerBound_Inverse = getResourceOrNull(graph, URIs.HasLowerBound_Inverse);
        HasModelingRules = getResourceOrNull(graph, URIs.HasModelingRules);
        HasSubgroup = getResourceOrNull(graph, URIs.HasSubgroup);
        HasTypeOverride = getResourceOrNull(graph, URIs.HasTypeOverride);
        HasUpperBound = getResourceOrNull(graph, URIs.HasUpperBound);
        HasUpperBound_Inverse = getResourceOrNull(graph, URIs.HasUpperBound_Inverse);
        InComposite = getResourceOrNull(graph, URIs.InComposite);
        InComposite_Inverse = getResourceOrNull(graph, URIs.InComposite_Inverse);
        InputDirection = getResourceOrNull(graph, URIs.InputDirection);
        InvalidSCLExpressionIssue = getResourceOrNull(graph, URIs.InvalidSCLExpressionIssue);
        IsBoundBy = getResourceOrNull(graph, URIs.IsBoundBy);
        IsConnectedTo = getResourceOrNull(graph, URIs.IsConnectedTo);
        IsDefinedBy = getResourceOrNull(graph, URIs.IsDefinedBy);
        IsIncludedInConnectionType = getResourceOrNull(graph, URIs.IsIncludedInConnectionType);
        IsIncludedInConnectionType_Inverse = getResourceOrNull(graph, URIs.IsIncludedInConnectionType_Inverse);
        IsJoinedBy = getResourceOrNull(graph, URIs.IsJoinedBy);
        Joins = getResourceOrNull(graph, URIs.Joins);
        JoinsComposite = getResourceOrNull(graph, URIs.JoinsComposite);
        ModelingRules = getResourceOrNull(graph, URIs.ModelingRules);
        MonitorValue = getResourceOrNull(graph, URIs.MonitorValue);
        MonitorValueType = getResourceOrNull(graph, URIs.MonitorValueType);
        OrderedComposite = getResourceOrNull(graph, URIs.OrderedComposite);
        OutputDirection = getResourceOrNull(graph, URIs.OutputDirection);
        OverridesConnectionType = getResourceOrNull(graph, URIs.OverridesConnectionType);
        OverridesConnectionType_Inverse = getResourceOrNull(graph, URIs.OverridesConnectionType_Inverse);
        ProceduralComponentType = getResourceOrNull(graph, URIs.ProceduralComponentType);
        ProceduralComponentTypeCode = getResourceOrNull(graph, URIs.ProceduralComponentTypeCode);
        ProceduralComponentType_code = getResourceOrNull(graph, URIs.ProceduralComponentType_code);
        ProceduralComponentType_code_Inverse = getResourceOrNull(graph, URIs.ProceduralComponentType_code_Inverse);
        ProceduralComponentType_environment = getResourceOrNull(graph, URIs.ProceduralComponentType_environment);
        Property = getResourceOrNull(graph, URIs.Property);
        ProvidingConnectionRelation = getResourceOrNull(graph, URIs.ProvidingConnectionRelation);
        ReplaceableDefinedComponentType = getResourceOrNull(graph, URIs.ReplaceableDefinedComponentType);
        Run = getResourceOrNull(graph, URIs.Run);
        SCLValue = getResourceOrNull(graph, URIs.SCLValue);
        SimpleModelingRules = getResourceOrNull(graph, URIs.SimpleModelingRules);
        StandardModelingRules = getResourceOrNull(graph, URIs.StandardModelingRules);
        SupportsConnectionType = getResourceOrNull(graph, URIs.SupportsConnectionType);
        SupportsDirection = getResourceOrNull(graph, URIs.SupportsDirection);
        SynchronizedConnectionRelation = getResourceOrNull(graph, URIs.SynchronizedConnectionRelation);
        SynchronizedRelation = getResourceOrNull(graph, URIs.SynchronizedRelation);
        TypeOverride = getResourceOrNull(graph, URIs.TypeOverride);
        TypeOverride_HasOriginalType = getResourceOrNull(graph, URIs.TypeOverride_HasOriginalType);
        TypeOverride_HasReplacementType = getResourceOrNull(graph, URIs.TypeOverride_HasReplacementType);
        UserDefinedProperty = getResourceOrNull(graph, URIs.UserDefinedProperty);
        input = getResourceOrNull(graph, URIs.input);
        input_Inverse = getResourceOrNull(graph, URIs.input_Inverse);
        scl = getResourceOrNull(graph, URIs.scl);
        sclValue = getResourceOrNull(graph, URIs.sclValue);
        structuralRevision = getResourceOrNull(graph, URIs.structuralRevision);
        structuralRevision_Inverse = getResourceOrNull(graph, URIs.structuralRevision_Inverse);
        synchronizedRevision = getResourceOrNull(graph, URIs.synchronizedRevision);
        synchronizedRevision_Inverse = getResourceOrNull(graph, URIs.synchronizedRevision_Inverse);
    }
    
    public static StructuralResource2 getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        StructuralResource2 ret = session.peekService(StructuralResource2.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new StructuralResource2(qc.getIndependentGraph(graph));
            session.registerService(StructuralResource2.class, ret);
        }
        return ret;
    }
    
    public static StructuralResource2 getInstance(RequestProcessor session) throws DatabaseException {
        StructuralResource2 ret = session.peekService(StructuralResource2.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<StructuralResource2>() {
                public StructuralResource2 perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new StructuralResource2(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(StructuralResource2.class, ret);
        }
        return ret;
    }
    
}

