/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver.formula.parser.ast;

import org.simantics.spreadsheet.solver.formula.PrintVisitor;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValueVisitor;

public class AstRange
implements AstValue {
    private static final long serialVersionUID = -2612788686679843356L;
    public static final AstRange REF = new AstRange("#REF!");
    public String sheetName;
    public String first;
    public String second;

    public AstRange(String sheetName, String first, String second) {
        this.sheetName = sheetName;
        this.first = first;
        this.second = second;
    }

    public AstRange(String token) {
        String[] parts = token.split(":");
        if (parts.length == 2) {
            this.first = parts[0];
            this.second = parts[1];
        } else {
            this.first = token;
        }
    }

    @Override
    public <T> T accept(AstValueVisitor<T> v) {
        return v.visit(this);
    }

    public boolean isCell() {
        return this.second == null;
    }

    public boolean isRef() {
        return this.second == null && "#REF!".equals(this.first);
    }

    public AstRange inSheet(String sheetName) {
        AstRange range = new AstRange(sheetName, this.first, this.second);
        return range;
    }

    public String toString() {
        return this.accept(new PrintVisitor());
    }
}

