/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.ui.DefaultLookup;

public class Renderer
extends JLabel
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 3056811790713043512L;
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private Color unselectedForeground;
    private Color unselectedBackground = new Color(240, 40, 40);

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(0, 0, 0, 0);
    }

    public Renderer() {
        this.setOpaque(true);
        this.setBorder(this.getNoFocusBorder());
        this.setName("Table.cellRenderer");
    }

    private Border getNoFocusBorder() {
        Border border = DefaultLookup.getBorder(this, this.ui, "Table.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value_, boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg = null;
        Color bg = null;
        CellValue value = (CellValue)value_;
        JTable.DropLocation dropLocation = table.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
            fg = DefaultLookup.getColor(this, this.ui, "Table.dropCellForeground");
            bg = DefaultLookup.getColor(this, this.ui, "Table.dropCellBackground");
            isSelected = true;
        }
        int hAlign = value.align & 3;
        int vAlign = value.align >> 2;
        if (hAlign == 0) {
            this.setHorizontalAlignment(2);
        } else if (hAlign == 1) {
            this.setHorizontalAlignment(0);
        } else if (hAlign == 2) {
            this.setHorizontalAlignment(4);
        }
        if (vAlign == 0) {
            this.setVerticalAlignment(1);
        } else if (vAlign == 1) {
            this.setVerticalAlignment(0);
        } else if (vAlign == 2) {
            this.setVerticalAlignment(3);
        }
        if (isSelected) {
            super.setForeground(fg == null ? table.getSelectionForeground() : fg);
            super.setBackground(bg == null ? table.getSelectionBackground() : bg);
        } else {
            Color background = value.background != null ? value.background : table.getBackground();
            Color foreground = value.foreground != null ? value.foreground : table.getForeground();
            super.setForeground(foreground);
            super.setBackground(background);
        }
        Font f = value.font;
        if (f != null) {
            this.setFont(f);
        } else {
            this.setFont(table.getFont());
        }
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = DefaultLookup.getBorder(this, this.ui, "Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = DefaultLookup.getBorder(this, this.ui, "Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = DefaultLookup.getColor(this, this.ui, "Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = DefaultLookup.getColor(this, this.ui, "Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(value.getBorder());
        }
        this.setValue(value.label);
        return this;
    }

    @Override
    public boolean isOpaque() {
        boolean colorMatch;
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean bl = colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || propertyName == "labelFor" || propertyName == "displayedMnemonic" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    public static class UIResource
    extends Renderer
    implements javax.swing.plaf.UIResource {
    }
}

