package org.simantics.spreadsheet.ui;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;

import javax.swing.JComponent;

import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.ClientModel;

public class SheetNode extends ComponentNode<JComponent> implements ActionListener, FocusListener {

    private static final long serialVersionUID = -8212264868316567181L;

    private SpreadsheetModel sm;

    public void init(Adaptable serverInterface) {

    	scale = true;
        sm = new SpreadsheetModel(serverInterface, null);
        component =  sm.createComponent(this);
        component.addFocusListener(this);
        
        super.init();

    }
    
    public ClientModel getModifier() {
    	return sm.getClientInterface();
    }

    protected ActionListener actionListener = null;

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @ServerSide
    @Override
    public void actionPerformed(ActionEvent e) {
        if(actionListener != null)
            actionListener.actionPerformed(e);
        if(container.getParent() != null)
            container.getParent().requestFocusInWindow(); // Loose focus
    }

    @Override
    @SyncField("bounds")
    public void setBounds(Rectangle2D bounds) {
    	this.bounds = bounds;
        container.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
        container.setSize((int)bounds.getWidth(), (int)bounds.getHeight());
        container.validate();
    }
    
    @Override
    public void render(Graphics2D g2d) {
        
        if(sm == null) return;
        if(sm.getTable() == null) return;
        
        container.validate();

        super.render(g2d);
        
    }

}
