/*******************************************************************************
 * Copyright (c) 2007- VTT Technical Research Centre of Finland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import java.awt.geom.AffineTransform;
import java.util.function.Consumer;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.operation.Layer0X;
import org.simantics.scenegraph.INode;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.resource.SpreadsheetResource;


/**
 * TODO: recognize experiment disposal and reset monitor contents at that point
 */
public class SheetFactory implements ElementFactory {

    public static ElementClass createSheetClass(Resource elementType) {
        return SheetClass.INSTANCE.newClassWith(new StaticObjectAdapter(elementType));//create(null, null, null, 1.0, 1.0, new StaticObjectAdapter(elementType));
    }

    @Override
    public void getClass(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram,
            Resource resource, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, createSheetClass(graph.getSession().getService(SpreadsheetResource.class).Spreadsheet));
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram,
            Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, createSheetClass(graph.getSession().getService(SpreadsheetResource.class).Spreadsheet));
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, final IDiagram diagram, final Resource resource, final IElement element, final AsyncProcedure<IElement> procedure) {

        final SpreadsheetResource sr = graph.getService(SpreadsheetResource.class);

        AffineTransform at = new AffineTransform();
        ElementUtils.setTransform(element, at);

        System.out.println("SheetFactory loads sheet at " + resource);

        graph.forPossibleObject(resource, sr.HasSheet, new AsyncProcedure<Resource>() {

            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            @Override
            public void execute(AsyncReadGraph g, final Resource sheet) {

                if (sheet != null) {

                    g.asyncRequest(new ReadRequest() {

                        @Override
                        public void run(ReadGraph graph) throws DatabaseException {

                            Layer0X L0X = Layer0X.getInstance(graph);
                            
                            final Session session = graph.getSession();

                            AffineTransform at = DiagramGraphUtil.getAffineTransform(graph, resource);
                            ElementUtils.setTransform(element, at);

//                            GraphBackend backend = new GraphBackend(session, session.getService(VirtualGraph.class));
                            final GraphUI ui = new GraphUI(session);

                            final String rvi = graph.getPossibleRelatedValue(resource, sr.HasRVI);
                            System.out.println("SheetFactory loads rvi = " + rvi);

                            final Resource model = graph.getResource((String)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_MODEL_URI));

                            Resource realization = graph.getPossibleObject(model, L0X.HasBaseRealization);

                            Variable base = graph.adapt(realization, Variable.class);
                            System.out.println("SheetFactory loads base = " + base.getURI(graph));

                            final Variable sheetVariable = base.browse(graph, rvi);

//                            try {
////                                backend.load(session, model, sheetVariable);
//
//                            } catch (DatabaseException e) {
//                                e.printStackTrace();
//                            }

                            element.setHint(SheetClass.KEY_SHEET, sheet);
                            element.setHint(SheetClass.KEY_RVI, rvi);

                            element.setHint(ElementHints.KEY_SG_CALLBACK, new Consumer<INode>() {

                                @Override
                                public void accept(INode _node) {

                                    final SheetNode node = (SheetNode)_node;

                                    try {
                                        ui.load(sheetVariable, node.getModifier());
                                    } catch (DatabaseException e) {
                                        e.printStackTrace();
                                    }

                                }

                            });


                            // This is called too early as backend.load is
                            // definitely not complete at this time, but right now that is
                            // acceptable from the implementation point-of-view.
                            procedure.execute(g, element);

                        }

                    });

                }

            }

        });

    }


}