package org.simantics.spreadsheet.synchronization;

import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetLines;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.utils.Solver;

public class LinesCommandBuilder implements CommandBuilder {

    private String name;
    int[] keys;

    public LinesCommandBuilder(String name, boolean update) {
        this.name = name;
    }

    @Override
    public void apply(Solver solver) {

        SpreadsheetBook book = solver.getConcreteSolver();
        SpreadsheetLines node = book.ensureSubprocess(name);
        node.setKeys(keys);

    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getConcrete() {
        return (T)this;
    }

}