/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.solver.formula.parser.ast;

public interface AstValueVisitor<T> {

	T visit(AstBoolean astBoolean);
	T visit(AstDouble astFloat);
	T visit(AstInteger astInteger);
	T visit(AstNull astNull);
	T visit(AstString astString);
	T visit(AstRange astSheetName);
	T visit(AstArgList astArgList);
	T visit(AstApply astApply);
	T visit(AstRelation astRelation);
	T visit(AstArithmeticExpression exp);
	T visit(AstTerm term);
	T visit(AstFactor factor);
	T visit(AstIdentifier id);
	T visit(AstArray array);
	T visit(AstNothing array);
	T visit(AstArrayFormulaReference ref);
	
}
