package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class IsErrorFormulaFunction implements CellFormulaFunction<Object>{

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {

        if (args.values.size() != 1) throw new IllegalStateException();

        Object condition = args.values.get(0).accept(visitor);
        if(condition instanceof String){
            FormulaError2 error = FormulaError2.forString((String)condition);
            return (error!=null);
        }
        return false;
    }
}