package org.simantics.spreadsheet.solver.formula;

import java.util.HashMap;
import java.util.Map;

import org.apache.poi.util.Internal;
import org.simantics.databoard.binding.mutable.Variant;

public enum FormulaError2{
    @Internal
    _NO_ERROR(-1, "(no error)"),NULL(0x00, "#NULL"),DIV0(0x07,"#DIV/0!"),VALUE(0x0F,
            "#VALUE!"),REF(0x17,"#REF!"),NAME(0x1D,"#NAME?"),NUM(0x24,"#NUM!"),NA(0x2A, "#N/A"),
    CIRCULAR_REF(0xFFFFFFC4, "~CIRCULAR~REF~"),FUNCTION_NOT_IMPLEMENTED(0xFFFFFFE2,"~FUNCTION~NOT~IMPLEMENTED~");

    private final String text;
    //private final Integer longType;
    //private final byte shortType;

    private static Map<String, FormulaError2> smap = new HashMap<String, FormulaError2>();

    private FormulaError2(int type, String text){
        //this.longType = type;
        //this.shortType = (byte)type;
        this.text = text;
    }

    static {
        for(FormulaError2 error : values()) {
            smap.put(error.getString(), error);
        }
    }

    public String getString(){
        return this.text;
    }

    public static FormulaError2 forString(String errorName){
        FormulaError2 err = smap.get(errorName);
        return err;
    }

    public static FormulaError2 forObject(Object errorObj){
        if(errorObj instanceof Variant)
            return forString(((Variant)errorObj).getValue().toString());
        else
            return forString(errorObj.toString());
    }

    public static String handleErrorCall(Object value){
        if(value==null) return VALUE.getString();
        FormulaError2 error = FormulaError2.forObject(value);
        if(error!=null) return error.getString();
        return VALUE.getString();
    }
}