/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.function;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.spreadsheet.graph.Ranges;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetRootVariable
extends StandardGraphChildVariable {
    public SpreadsheetRootVariable(Variable parent, VariableNode<?> node, Resource resource) {
        super(parent, node, resource);
    }

    public String getName(ReadGraph graph) throws DatabaseException {
        return "<<<";
    }

    public Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        return new ConstantPropertyVariable((Variable)this, "HasName", (Object)"<<<", (Binding)Bindings.STRING);
    }

    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        Variable var = super.getPossibleChild(graph, name);
        if (var == null) {
            var = this.getPossibleRangeChild(graph, (Variable)this, name);
        }
        if (var == null) {
            var = this.getPossibleDeepChild(graph, (Variable)this, name);
        }
        return var;
    }

    private Variable getPossibleDeepChild(ReadGraph graph, Variable context, String name) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        for (Variable range : (Collection)graph.syncRequest((Read)new Ranges(context), (Listener)TransientCacheListener.instance())) {
            Variable cell;
            String location = (String)range.getPropertyValue(graph, SHEET.Range_location, (Binding)Bindings.STRING);
            Integer widthBound = (Integer)range.getPropertyValue(graph, SHEET.Range_widthBound, (Binding)Bindings.INTEGER);
            Integer heightBound = (Integer)range.getPropertyValue(graph, SHEET.Range_heightBound, (Binding)Bindings.INTEGER);
            if (!SpreadsheetUtils.isInBounds((String)location, (String)name, (int)widthBound, (int)heightBound) || (cell = range.getPossibleChild(graph, name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Variable getPossibleRangeChild(ReadGraph graph, Variable context, String name) throws DatabaseException {
        String[] propertyNames = new String[]{"content", "rangeCellNames", "HasLabel", "immutable"};
        Binding[] bindingArray = new Binding[4];
        bindingArray[0] = Bindings.VARIANT;
        bindingArray[2] = Bindings.STRING;
        bindingArray[3] = Bindings.BOOLEAN;
        Binding[] bindings = bindingArray;
        if (name.contains(":")) {
            Range range = Spreadsheets.decodeRange((String)name, (int)0, (int)0);
            VariantMatrix matrix = new VariantMatrix(range.height(), range.width());
            String[][] rangeNames = new String[range.height()][range.width()];
            int x = range.startColumn;
            while (x <= range.endColumn) {
                int y = range.startRow;
                while (y <= range.endRow) {
                    String location = Spreadsheets.cellName((int)y, (int)x);
                    Variable child = context.getPossibleChild(graph, location);
                    Variant value = null;
                    if (child != null) {
                        value = (Variant)child.getPossiblePropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                    }
                    matrix.set(y - range.startRow, x - range.startColumn, value);
                    rangeNames[y - range.startRow][x - range.startColumn] = location;
                    ++y;
                }
                ++x;
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = Variant.ofInstance((Object)matrix);
            objectArray[1] = rangeNames;
            objectArray[3] = name;
            objectArray[4] = Boolean.FALSE;
            Object[] values = objectArray;
            ArrayList<ConstantPropertyVariableBuilder> list = new ArrayList<ConstantPropertyVariableBuilder>();
            int i = 0;
            while (i < propertyNames.length) {
                list.add(new ConstantPropertyVariableBuilder(propertyNames[i], values[i], bindings[i]));
                ++i;
            }
            return new ConstantChildVariable(context, name, list);
        }
        return null;
    }
}

