package org.simantics.spreadsheet.graph.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.common.cell.VariableCellEditor;

public class CellVariable extends StandardGraphChildVariable {

	public CellVariable(Variable parent, Resource resource) throws DatabaseException {
		super(parent, null, resource);
	}
	
	@Override
	public String getLabel(ReadGraph graph) throws DatabaseException {
		return null;
	}
	
    @SuppressWarnings("unchecked")
    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
    	if(VariableCellEditor.class == clazz) {
    		return (T)new VariableCellEditor() {
				
				@Override
				public void edit(WriteGraph graph, Variable cell, String text) throws DatabaseException {
				}
				
				@Override
				public void copy(WriteGraph graph, Variable cell, String location) throws DatabaseException {
				}
				
			};
    	}
    	return null;
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = tryAdapt(graph, clazz);
        return t != null ? t : super.adapt(graph, clazz);
    }

    @Override
    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = tryAdapt(graph, clazz);
        return t != null ?  t : super.adaptPossible(graph, clazz);
    }

}
