/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common.expression.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.simantics.spreadsheet.common.expression.lexer.LexerException;
import org.simantics.spreadsheet.common.expression.node.EOF;
import org.simantics.spreadsheet.common.expression.node.TAmpersand;
import org.simantics.spreadsheet.common.expression.node.TBlank;
import org.simantics.spreadsheet.common.expression.node.TCell;
import org.simantics.spreadsheet.common.expression.node.TColon;
import org.simantics.spreadsheet.common.expression.node.TComma;
import org.simantics.spreadsheet.common.expression.node.TDiv;
import org.simantics.spreadsheet.common.expression.node.TEqual;
import org.simantics.spreadsheet.common.expression.node.TFunc;
import org.simantics.spreadsheet.common.expression.node.TGreaterThan;
import org.simantics.spreadsheet.common.expression.node.TLPar;
import org.simantics.spreadsheet.common.expression.node.TLessThan;
import org.simantics.spreadsheet.common.expression.node.TMinus;
import org.simantics.spreadsheet.common.expression.node.TMult;
import org.simantics.spreadsheet.common.expression.node.TNewLine;
import org.simantics.spreadsheet.common.expression.node.TNumber;
import org.simantics.spreadsheet.common.expression.node.TPlus;
import org.simantics.spreadsheet.common.expression.node.TRPar;
import org.simantics.spreadsheet.common.expression.node.TString;
import org.simantics.spreadsheet.common.expression.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    static {
        try {
            int j;
            DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int length = s.readInt();
            gotoTable = new int[length][][][];
            int i = 0;
            while (i < gotoTable.length) {
                length = s.readInt();
                Lexer.gotoTable[i] = new int[length][][];
                j = 0;
                while (j < gotoTable[i].length) {
                    length = s.readInt();
                    Lexer.gotoTable[i][j] = new int[length][3];
                    int k = 0;
                    while (k < gotoTable[i][j].length) {
                        int l = 0;
                        while (l < 3) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            length = s.readInt();
            accept = new int[length][];
            i = 0;
            while (i < accept.length) {
                length = s.readInt();
                Lexer.accept[i] = new int[length];
                j = 0;
                while (j < accept[i].length) {
                    Lexer.accept[i][j] = s.readInt();
                    ++j;
                }
                ++i;
            }
            s.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block25: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block25;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(int line, int pos) {
        return new TLessThan(line, pos);
    }

    Token new1(int line, int pos) {
        return new TGreaterThan(line, pos);
    }

    Token new2(int line, int pos) {
        return new TEqual(line, pos);
    }

    Token new3(int line, int pos) {
        return new TPlus(line, pos);
    }

    Token new4(int line, int pos) {
        return new TMinus(line, pos);
    }

    Token new5(int line, int pos) {
        return new TMult(line, pos);
    }

    Token new6(int line, int pos) {
        return new TDiv(line, pos);
    }

    Token new7(int line, int pos) {
        return new TAmpersand(line, pos);
    }

    Token new8(int line, int pos) {
        return new TComma(line, pos);
    }

    Token new9(int line, int pos) {
        return new TColon(line, pos);
    }

    Token new10(int line, int pos) {
        return new TLPar(line, pos);
    }

    Token new11(int line, int pos) {
        return new TRPar(line, pos);
    }

    Token new12(String text, int line, int pos) {
        return new TFunc(text, line, pos);
    }

    Token new13(String text, int line, int pos) {
        return new TCell(text, line, pos);
    }

    Token new14(String text, int line, int pos) {
        return new TNumber(text, line, pos);
    }

    Token new15(String text, int line, int pos) {
        return new TString(text, line, pos);
    }

    Token new16(String text, int line, int pos) {
        return new TNewLine(text, line, pos);
    }

    Token new17(String text, int line, int pos) {
        return new TBlank(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        int i = length - 1;
        while (i >= acceptLength) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
            --i;
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        int i = length - 1;
        while (i >= 0) {
            this.eof = false;
            this.in.unread(text.charAt(i));
            --i;
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        int i = 0;
        while (i < acceptLength) {
            s.append(this.text.charAt(i));
            ++i;
        }
        return s.toString();
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

