/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.common.cell;

import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.PropertyCreationData;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class Parsers {

	final public static String LABEL_PROPERTY = Layer0.URIs.HasLabel;
	final public static String CONTENT_PROPERTY = SpreadsheetResource.URIs.Cell_content;
	final public static String EXPRESSION_PROPERTY = "e";
	final public static String RESOURCE_PATH_PROPERTY = "r";
	
    final public static StringCellParser TEXT_PARSER = new TextStringCellParser();
    
    final public static StringCellParser RESOURCE_ARRAY_PARSER = new StringCellParser() {

        @Override
        public Collection<PropertyCreationData> parse(String text) {
            if(text.startsWith("=")) {
                return Collections.singletonList(PropertyCreationData.build(Parsers.RESOURCE_PATH_PROPERTY, Variant.ofInstance(text)));
            } else {
                return null;
            }
        }

        @Override
        public String getType() { 
        	return null;
        }
        
    };
    
    final public static StringCellParser EXPRESSION_PARSER = new ExpressionStringCellParser();

    final public static StringCellParser COMMAND_PARSER = new CommandStringCellParser();

    final public static StringCellParser MATRIX_PARSER = new MatrixStringCellParser();

}
