/*******************************************************************************
 * Copyright (c) 2013, 2014 Association for Decentralized 
 * Information Management in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the THTH Simantics 
 * Division Member Component License which accompanies this 
 * distribution, and is available at
 * http://www.simantics.org/legal/sdmcl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.common;

import org.simantics.document.server.io.IColor;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITableCell;

public class TableCell implements ITableCell {

	public int column;
	public int row;
	public int border;
	public int align;
	public String text;
	public IFont font;
	public IColor foreground;
	public IColor background;
	public boolean locked;
	public int rowSpan = 1;
	public int columnSpan = 1;
	
	public TableCell() {
		
	}

	public TableCell(int column, int row, int border, int align, String text,
			IFont font, IColor foreground, IColor background, boolean locked,
			int rowSpan, int columnSpan) {
		super();
		this.column = column;
		this.row = row;
		this.border = border;
		this.align = align;
		this.text = text;
		this.font = font;
		this.foreground = foreground;
		this.background = background;
		this.locked = locked;
		this.rowSpan = rowSpan;
		this.columnSpan = columnSpan;
	}
	
	public TableCell(ITableCell other) {
		this(other.getColumn(), other.getRow(), other.getBorder(), other.getAlign(),
				other.getText(),other.getFont(), other.getFGColor(), other.getBGColor(),
				other.getLocked(), other.getRowSpan(), other.getColumnSpan());
	}
	
	@Override
	public String getText() {
		return text;
	}
	@Override
	public int getColumn() {
		return column;
	}
	@Override
	public int getBorder() {
		return border;
	}
	@Override
	public int getAlign() {
		return align;
	}
	@Override
	public int getRow() {
		return row;
	}
	@Override
	public IFont getFont() {
		return font;
	}

	@Override
	public IColor getFGColor() {
		return foreground;
	}

	@Override
	public IColor getBGColor() {
		return background;
	}
	
	@Override
	public boolean getLocked() {
		return locked;
	}
	
	@Override
	public int getRowSpan() {
		return rowSpan;
	}
	
	@Override
	public int getColumnSpan() {
		return columnSpan;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + align;
		result = prime * result
				+ ((background == null) ? 0 : background.hashCode());
		result = prime * result + border;
		result = prime * result + column;
		result = prime * result + columnSpan;
		result = prime * result + ((font == null) ? 0 : font.hashCode());
		result = prime * result
				+ ((foreground == null) ? 0 : foreground.hashCode());
		result = prime * result + (locked ? 1231 : 1237);
		result = prime * result + row;
		result = prime * result + rowSpan;
		result = prime * result + ((text == null) ? 0 : text.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TableCell other = (TableCell) obj;
		if (align != other.align)
			return false;
		if (background == null) {
			if (other.background != null)
				return false;
		} else if (!background.equals(other.background))
			return false;
		if (border != other.border)
			return false;
		if (column != other.column)
			return false;
		if (columnSpan != other.columnSpan)
			return false;
		if (font == null) {
			if (other.font != null)
				return false;
		} else if (!font.equals(other.font))
			return false;
		if (foreground == null) {
			if (other.foreground != null)
				return false;
		} else if (!foreground.equals(other.foreground))
			return false;
		if (locked != other.locked)
			return false;
		if (row != other.row)
			return false;
		if (rowSpan != other.rowSpan)
			return false;
		if (text == null) {
			if (other.text != null)
				return false;
		} else if (!text.equals(other.text))
			return false;
		return true;
	}

	
}
