package org.simantics.simulator.toolkit;

import java.util.Map;

import org.simantics.databoard.binding.Binding;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

/**
 * This interface is a simplified version of {@link NodeManager} that only
 * provides node structure retrieval and property value getting and setting
 * without regard to realms or listeners.
 * 
 * This used to exist in org.simantics.db.layer0 in earlier versions but was
 * moved here to make it DB-independent.
 * 
 * @author Antti Villberg
 * @since 1.34.0
 * @param <Node>
 */
public interface StandardNodeManagerSupport<Node> {

	Object getEngineValue(Node node) throws NodeManagerException;
	Binding getEngineBinding(Node node) throws NodeManagerException;
	void setEngineValue(Node node, Object value) throws NodeManagerException;
	String getName(Node node);
	Map<String,Node> getChildren(Node node);
	Map<String,Node> getProperties(Node node);

}
