/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulator;

import org.eclipse.core.runtime.IProgressMonitor;

public interface IExperimentLocal {

    <T> T getService(Class<T> clazz);

    String getIdentifier();

    /**
     * @param monitor
     *            the progress monitor to use for reporting progress to the user
     *            during the operation. It is the caller's responsibility to
     *            call done() on the given monitor. Accepts null, indicating
     *            that no progress should be reported and that the operation
     *            cannot be cancelled.
     */
    void shutdown(IProgressMonitor monitor);

    ExperimentState getStateL();
    void changeStateL(ExperimentState state);

}
