/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.model;

/**
 * Used in
 * {@link IModel#loadExperiment(org.simantics.db.ReadGraph, org.simantics.db.Resource, org.simantics.simulation.project.IExperimentActivationListener)}
 * to indicate that experiment activation has been cancelled in a controlled
 * manner and that no errors should be issued to the user.
 * 
 * <p>
 * It is possible to provide a {@link Runnable} action through
 * {@link #ExperimentLoadingCancelled(String, Runnable)} that will be executed.
 * 
 * @author Tuukka Lehtonen
 */
public class ExperimentLoadingCancelled extends ExperimentLoadingFailed {

    private static final long serialVersionUID = -1465266288034655364L;

    public ExperimentLoadingCancelled() {
        super();
    }

    public ExperimentLoadingCancelled(String arg0, Throwable arg1) {
        super(arg0, arg1);
    }

    public ExperimentLoadingCancelled(String arg0) {
        super(arg0);
    }

    public ExperimentLoadingCancelled(String arg0, Runnable helperAction) {
        super(arg0, helperAction);
    }

    public ExperimentLoadingCancelled(Throwable arg0) {
        super(arg0);
    }

}
