/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.swt.TabbedPropertyPage;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.PageSiteProxy;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.TabChangeEvent;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;

public class TabbedPropertyTable
extends Composite
implements IPropertyTab {
    public static final SelectionProcessor<Object, Object> DEFAULT_SELECTION_PROCESSOR = new SelectionProcessor<Object, Object>(){

        @Override
        public Collection<?> process(Object selection, Object object) {
            return Collections.emptyList();
        }
    };
    private SelectionProcessor selectionProcessor = DEFAULT_SELECTION_PROCESSOR;
    private Composite baseComposite;
    private final List<IPropertyTab> tabs = new CopyOnWriteArrayList<IPropertyTab>();
    private final AtomicInteger activeTab = new AtomicInteger(-1);
    protected IWorkbenchPartSite sourceSite;
    protected IPageSite pageSite;
    protected ISelection currentSelection;
    protected BasePostSelectionProvider pageSelectionProvider = new BasePostSelectionProvider(){
        private AtomicBoolean settingSelection = new AtomicBoolean();

        public void setSelection(ISelection selection) {
            if (this.settingSelection.compareAndSet(false, true)) {
                IPropertyTab table = TabbedPropertyTable.this.getActiveTab();
                if (table != null && table.getSelectionProvider() != null) {
                    table.getSelectionProvider().setSelection(selection);
                }
                this.settingSelection.set(false);
            } else {
                ErrorLogger.defaultLogWarning((String)("Possible BUG: prevented recursive attempt to set selection for " + TabbedPropertyTable.this.toString()), (Throwable)new Exception("trace"));
            }
        }
    };
    protected ISelectionChangedListener activeTabSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection s = event.getSelection();
            TabbedPropertyTable.this.pageSelectionProvider.setSelectionWithoutFiring(s);
            TabbedPropertyTable.this.pageSelectionProvider.fireSelection(s);
            TabbedPropertyTable.this.pageSelectionProvider.firePostSelection(s);
        }
    };
    protected LocalResourceManager resourceManager;
    InputListener currentListener = null;

    public TabbedPropertyTable(IWorkbenchPartSite site, IPageSite pageSite, Composite parent, int style) {
        super(parent, style);
        if (site == null) {
            throw new IllegalArgumentException("null source site");
        }
        if (pageSite == null) {
            throw new IllegalArgumentException("null page site");
        }
        this.sourceSite = site;
        this.pageSite = pageSite;
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TabbedPropertyTable.this.activeTab.set(-1);
                TabbedPropertyTable.this.tabs.clear();
                TabbedPropertyTable.this.currentSelection = null;
                if (TabbedPropertyTable.this.currentListener != null) {
                    TabbedPropertyTable.this.currentListener.dispose();
                }
                TabbedPropertyTable.this.pageSite = null;
                TabbedPropertyTable.this.sourceSite = null;
                TabbedPropertyTable.this.resourceManager.dispose();
            }
        });
    }

    protected void setSelectionProcessor(SelectionProcessor selectionProcessor) {
        this.selectionProcessor = selectionProcessor;
    }

    @Override
    public void createControl(Composite parent, ISessionContext context) {
        this.createBaseComposite(parent, null);
    }

    @Override
    public void setInput(ISessionContext context, ISelection selection, boolean force) {
        if (this.isDisposed()) {
            return;
        }
        if (context == null) {
            return;
        }
        if (!force && ObjectUtils.objectEquals((Object)this.currentSelection, (Object)selection)) {
            return;
        }
        this.currentSelection = selection;
        if (this.selectionProcessor != null) {
            List contents;
            if (this.currentListener != null) {
                this.currentListener.dispose();
            }
            if ((contents = ISelectionUtils.convertSelection((ISelection)selection)).isEmpty()) {
                return;
            }
            this.currentListener = new InputListener(this.inputCallback(contents, context));
            context.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    graph.syncRequest((Read)new UniqueRead<Collection<?>>(){

                        public Collection<?> perform(ReadGraph graph) throws DatabaseException {
                            return (this).TabbedPropertyTable.this.selectionProcessor.process(contents, graph);
                        }
                    }, (org.simantics.db.procedure.Listener)TabbedPropertyTable.this.currentListener);
                }
            });
        }
    }

    protected Consumer<Collection<?>> inputCallback(final Collection<Object> selectionContents, final ISessionContext sessionContext) {
        return new Consumer<Collection<?>>(){

            @Override
            public void accept(final Collection<?> contribs) {
                if (TabbedPropertyTable.this.isDisposed()) {
                    return;
                }
                SimanticsUI.asyncExecSWT((Widget)TabbedPropertyTable.this, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!TabbedPropertyTable.this.isVisible()) {
                            (this).TabbedPropertyTable.this.currentSelection = null;
                            return;
                        }
                        TabbedPropertyTable.this.createBaseComposite(TabbedPropertyTable.this, new TabbedPropertyPage((this).TabbedPropertyTable.this.sourceSite.getPart()){
                            ISelectionProvider[] tabSelectionProviders;
                            {
                                super($anonymous0);
                                this.tabSelectionProviders = new ISelectionProvider[1];
                            }

                            protected void initializePageSwitching() {
                            }

                            protected int getContainerStyle() {
                                return TabbedPropertyTable.this.getTabFolderStyle();
                            }

                            protected void pageChange(int newPageIndex) {
                                ISelectionProvider pv;
                                ISelectionProvider pv2;
                                int oldActiveTab = ((this).this).TabbedPropertyTable.this.activeTab.getAndSet(newPageIndex);
                                super.pageChange(newPageIndex);
                                ISelection oldSelection = null;
                                IPropertyTab oldTab = null;
                                if (oldActiveTab > -1 && (pv2 = (oldTab = ((this).this).TabbedPropertyTable.this.tabs.get(oldActiveTab)).getSelectionProvider()) != null) {
                                    oldSelection = pv2.getSelection();
                                    pv2.removeSelectionChangedListener(((this).this).TabbedPropertyTable.this.activeTabSelectionListener);
                                }
                                ISelection activeSelection = null;
                                IPropertyTab activeTab = TabbedPropertyTable.this.getActiveTab();
                                if (activeTab != null && (pv = activeTab.getSelectionProvider()) != null) {
                                    activeSelection = pv.getSelection();
                                    pv.addSelectionChangedListener(((this).this).TabbedPropertyTable.this.activeTabSelectionListener);
                                }
                                String oldLabel = null;
                                String newLabel = null;
                                if (oldActiveTab > -1) {
                                    oldLabel = this.getPageText(oldActiveTab);
                                }
                                if (newPageIndex > -1) {
                                    newLabel = this.getPageText(newPageIndex);
                                }
                                TabbedPropertyTable.this.activeTabChanged(new TabChangeEvent(oldTab, oldLabel, activeTab, newLabel));
                                ((this).this).TabbedPropertyTable.this.pageSelectionProvider.setSelectionWithoutFiring(activeSelection);
                                if (!ObjectUtils.objectEquals((Object)oldSelection, (Object)activeSelection)) {
                                    ((this).this).TabbedPropertyTable.this.pageSelectionProvider.fireSelection(activeSelection);
                                    ((this).this).TabbedPropertyTable.this.pageSelectionProvider.firePostSelection(activeSelection);
                                }
                            }

                            protected void createPages() {
                                MapList ml = new MapList();
                                for (Object o : contribs) {
                                    if (o instanceof ComparableTabContributor) {
                                        ComparableTabContributor c = (ComparableTabContributor)o;
                                        ml.add((Object)c.getId(), (Object)c);
                                        continue;
                                    }
                                    System.out.println("WARNING: SelectionProcessor produced an unusable contribution to TabbedPropertyTable: " + o);
                                }
                                TreeSet<ComparableTabContributor> contributions = new TreeSet<ComparableTabContributor>();
                                for (String key : ml.getKeys()) {
                                    TreeSet ts = new TreeSet(ml.getValuesUnsafe((Object)key));
                                    ComparableTabContributor contrib = (ComparableTabContributor)ts.first();
                                    contributions.add(contrib);
                                }
                                ArrayList<ComparableTabContributor> contributionList = new ArrayList<ComparableTabContributor>(contributions);
                                if (contributions.isEmpty()) {
                                    Composite empty = this.createEmptyControl(this.getContainer(), 0);
                                    this.addPage((Control)empty, "No properties to show", null);
                                } else {
                                    int activePage;
                                    ComparableTabContributor cc2;
                                    ((this).this).TabbedPropertyTable.this.pageSite.setSelectionProvider((ISelectionProvider)((this).this).TabbedPropertyTable.this.pageSelectionProvider);
                                    this.tabSelectionProviders = new ISelectionProvider[contributions.size()];
                                    int index = 0;
                                    for (ComparableTabContributor cc2 : contributionList) {
                                        Composite middleware = new Composite(this.getContainer(), 0);
                                        GridLayoutFactory.fillDefaults().applyTo(middleware);
                                        Composite control = null;
                                        final int tabIndex = index++;
                                        PageSiteProxy siteWrapper = new PageSiteProxy(((this).this).TabbedPropertyTable.this.pageSite){

                                            @Override
                                            public void setSelectionProvider(ISelectionProvider provider) {
                                                tabSelectionProviders[tabIndex] = provider;
                                                if ((((this).this).this).TabbedPropertyTable.this.pageSelectionProvider != null && provider != null) {
                                                    (((this).this).this).TabbedPropertyTable.this.pageSelectionProvider.setAndFireNonEqualSelection(provider.getSelection());
                                                }
                                            }

                                            @Override
                                            public ISelectionProvider getSelectionProvider() {
                                                return tabSelectionProviders[tabIndex];
                                            }
                                        };
                                        IPropertyTab tab = cc2.create(middleware, (IWorkbenchSite)siteWrapper, sessionContext, cc2.getInput());
                                        if (tab != null) {
                                            ((this).this).TabbedPropertyTable.this.tabs.add(tab);
                                            control = tab.getControl();
                                            if (control != null && !control.isDisposed()) {
                                                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)control);
                                            }
                                        } else {
                                            control = this.createEmptyControl(middleware, 0);
                                        }
                                        this.addPage((Control)middleware, cc2.getLabel(), cc2.getImage());
                                        if (tab == null) continue;
                                        Object input = cc2.getInput();
                                        tab.setInput(sessionContext, (ISelection)new StructuredSelection(input), false);
                                    }
                                    cc2 = TabbedPropertyTable.this.selectInitialTab(selectionContents, contributionList);
                                    if (cc2 != null && (activePage = contributionList.indexOf(cc2)) != -1) {
                                        this.setActivePage(activePage);
                                    }
                                }
                            }

                            Composite createEmptyControl(Composite parent, int flags) {
                                Composite empty = new Composite(parent, flags);
                                GridLayoutFactory.fillDefaults().applyTo(empty);
                                return empty;
                            }
                        });
                        TabbedPropertyTable.this.layout();
                    }
                });
            }
        };
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void requestFocus() {
        IPropertyTab table = this.getActiveTab();
        if (table != null) {
            table.requestFocus();
        }
    }

    public IPropertyTab getActiveTab() {
        int index = this.activeTab.get();
        if (index < 0 || index >= this.tabs.size()) {
            return null;
        }
        IPropertyTab tab = this.tabs.get(index);
        return tab;
    }

    protected Composite createBaseComposite(Composite parent, TabbedPropertyPage page) {
        this.disposeAll();
        this.baseComposite = new Composite(parent, 0);
        if (page != null) {
            page.createPartControl(this.baseComposite);
        }
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.baseComposite);
        this.baseComposite.setLayout((Layout)new FillLayout());
        return this.baseComposite;
    }

    private void disposeAll() {
        if (this.baseComposite != null && !this.baseComposite.isDisposed()) {
            this.baseComposite.dispose();
            this.baseComposite = null;
        }
        this.activeTab.set(-1);
        for (IPropertyTab tab : this.tabs) {
            tab.dispose();
        }
        this.tabs.clear();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.pageSelectionProvider;
    }

    protected void activeTabChanged(TabChangeEvent event) {
    }

    protected ComparableTabContributor selectInitialTab(Collection<Object> selectionContents, Collection<ComparableTabContributor> contributions) {
        return null;
    }

    protected int getTabFolderStyle() {
        return 0;
    }

    class InputListener
    implements org.simantics.db.procedure.Listener<Collection<?>> {
        private final Consumer<Collection<?>> inputCallback;
        private boolean disposed = false;

        public InputListener(Consumer<Collection<?>> inputCallback) {
            this.inputCallback = inputCallback;
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }

        public void execute(Collection<?> result) {
            this.inputCallback.accept(result);
        }

        public boolean isDisposed() {
            return this.disposed || TabbedPropertyTable.this.isDisposed();
        }

        public void dispose() {
            this.disposed = true;
        }
    }
}

