/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.Page;
import org.simantics.ui.workbench.IPropertyPage;

public abstract class AbstractPropertyPage
extends Page
implements IPropertyPage {
    private final PartListener partListener = new PartListener();
    protected IWorkbenchPartSite sourceSite;
    protected IWorkbenchPart sourcePart;

    public AbstractPropertyPage(IWorkbenchPartSite sourceSite) {
        this.sourceSite = sourceSite;
    }

    public void dispose() {
        super.dispose();
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
            this.sourcePart = null;
        }
        this.sourceSite = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getControl() == null) {
            return;
        }
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
            this.sourcePart = null;
        }
        this.sourcePart = part;
        this.sourceSelectionChanged(selection);
        if (this.sourcePart != null) {
            IWorkbenchPartSite site = this.sourcePart.getSite();
            if (site == null) {
                new Exception("null site").printStackTrace();
                return;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                new Exception("null page").printStackTrace();
                return;
            }
            page.addPartListener((IPartListener)this.partListener);
        }
    }

    protected abstract void sourceSelectionChanged(ISelection var1);

    protected abstract void sourcePartClosed(IWorkbenchPart var1);

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (AbstractPropertyPage.this.sourcePart == part) {
                AbstractPropertyPage.this.sourcePart = null;
                AbstractPropertyPage.this.sourcePartClosed(part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

