package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.simantics.ui.selection.WorkbenchSelectionElement;

final public class StandardSelectionInput implements SelectionInput {
	
	private final Collection<WorkbenchSelectionElement> elements;
	private final Map<String, Object> parameters;
	
	public StandardSelectionInput(Collection<WorkbenchSelectionElement> elements, Map<String, Object> parameters) {
		this.parameters = new HashMap<String, Object>(parameters);
		this.elements = new ArrayList<WorkbenchSelectionElement>(elements);
	}
	
	public StandardSelectionInput(WorkbenchSelectionElement element, Map<String, Object> parameters) {
		this.parameters = new HashMap<String, Object>(parameters);
		this.elements = Collections.singletonList(element);
	}

	public StandardSelectionInput(WorkbenchSelectionElement element) {
		this.parameters = Collections.emptyMap();
		this.elements = Collections.singletonList(element);
	}

	public Collection<WorkbenchSelectionElement> getElements() {
		return elements;
	}
	
	public <T> T getParameter(String key) {
		return (T)parameters.get(key);
	}
	
	@Override
	public int hashCode() {
		return elements.hashCode() + 31 * parameters.hashCode();
	}
	
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof StandardSelectionInput))
            return false;
        StandardSelectionInput ssi = (StandardSelectionInput)object;
        if(!elements.equals(ssi.elements)) return false;
        return parameters.equals(ssi.parameters);
	}

	@Override
	public String toString() {
		return "StandardSelectionInput[es=" + elements + ", par=" + parameters + "]";
	}
	
}
