package org.simantics.selectionview;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class SCLTabContribution implements TabContribution<Object> {

	final private TabContribution<Object> contribution;
	
	public SCLTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		Variable var = Variables.getVariable(graph, configuration);
		Function1<Object, TabContribution<Object>> function = var.getPropertyValue(graph, "instantiate");
		contribution = function.apply(Tuple0.INSTANCE);
	}

	@Override
	public boolean accept(ReadGraph graph, Object input) throws DatabaseException {
		return contribution.accept(graph, input);
	}

	@Override
	public void contribute(ReadGraph graph, Object selection, Collection<ComparableTabContributor> result)
			throws DatabaseException {
		contribution.contribute(graph, selection, result);
	}

}
