/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionProcessor;

/**
 * A {@link PropertyTabContributor} is used to encapsulate initialization of the
 * controls of a single tab control within a tabbed property page.
 * PropertyTabContributors are created internally by {@link SelectionProcessor}
 * implementations.
 * 
 * <p>
 * {@link ComparableTabContributor} is used for ordering a set of
 * {@link PropertyTabContributor}s according to their designated priority. This
 * is necessary to make the tabbed UI presentation order deterministic.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ComparableTabContributor
 */
public interface PropertyTabContributor {

    /**
     * Creates and initializes a property tab (see {@link IPropertyTab}).
     * 
     * @param parent the parent composite for the property tab to create
     * @param site site of the {@link PageBook} page this TabbedPropertyTable
     *        contributes to (see {@link IPageSite})
     * @param context the current database session context
     * @param input processed input provided internally by
     *        {@link SelectionProcessor} implementations. Do not pass this on,
     *        to get input for property tab, wait for invocations to
     *        {@link IPropertyTab#setInput(ISessionContext, org.eclipse.jface.viewers.ISelection, boolean)}
     *        instead
     * @return the created property tab control
     */
    IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input);

}