/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.part.IPageSite;

/**
 * @author Tuukka Lehtonen
 */
public class PageSiteProxy implements IPageSite, INestable {

    IPageSite proxy;

    public PageSiteProxy(IPageSite proxy) {
        this.proxy = proxy;
    }

    @Override
    public IWorkbenchPage getPage() {
        return proxy.getPage();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return proxy.getSelectionProvider();
    }

    @Override
    public Shell getShell() {
        return proxy.getShell();
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return proxy.getWorkbenchWindow();
    }

    @Override
    public void setSelectionProvider(ISelectionProvider provider) {
        proxy.setSelectionProvider(provider);
    }

    @Override
    public Object getAdapter(Class adapter) {
        return proxy.getAdapter(adapter);
    }

    @Override
    public Object getService(Class api) {
        return proxy.getService(api);
    }

    @Override
    public boolean hasService(Class api) {
        return proxy.hasService(api);
    }

    @Override
    public void activate() {
        if (proxy instanceof INestable)
            ((INestable) proxy).activate();
    }

    @Override
    public void deactivate() {
        if (proxy instanceof INestable)
            ((INestable) proxy).deactivate();
    }

    @Override
    public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        proxy.registerContextMenu(menuId, menuManager, selectionProvider);
    }

    @Override
    public IActionBars getActionBars() {
        return proxy.getActionBars();
    }

}