/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.compiler.commands.SCLConsoleListener;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.osgi.internal.TestUtils;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.console.ConsoleActions;
import org.simantics.scl.ui.console.Messages;
import org.simantics.scl.ui.console.SCLConsole;
import org.simantics.scl.ui.imports.internal.ManageImportsDialog;
import org.simantics.scl.ui.tests.SCLTestsDialog;

public class SCLConsoleView
extends ViewPart {
    public static final String PLUGIN_ID = "org.simantics.scl.ui";
    public static final String IMPORTS = "imports";
    public static final String REFRESH_AUTOMATICALLY = "refresh-automatically";
    public static final String SEPARATOR = ";";
    public static final String DISABLED_TAG = "[DISABLED]";
    IPersistentPreferenceStore store;
    SCLConsole console;
    boolean refreshAutomatically = false;
    MenuItem refreshAutomaticallyItem;
    AtomicReference<ArrayList<CommandSessionImportEntry>> assignedImports = new AtomicReference();
    SetImportsJob setImportsJob = new SetImportsJob();
    private UpdateListener dependencyListener = new UpdateListener(){

        public void notifyAboutUpdate() {
            if (SCLConsoleView.this.refreshAutomatically) {
                SCLConsoleView.this.console.getSession().updateRuntimeEnvironment(true);
            }
        }
    };

    private ArrayList<CommandSessionImportEntry> readImportPreferences() {
        String importsString = this.store.getString(IMPORTS);
        String[] splitted = importsString.split(SEPARATOR);
        ArrayList<CommandSessionImportEntry> result = new ArrayList<CommandSessionImportEntry>(splitted.length);
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String entryString = stringArray[n2];
            if (!entryString.isEmpty()) {
                String[] parts;
                boolean disabled = false;
                if (entryString.startsWith(DISABLED_TAG)) {
                    disabled = true;
                    entryString = entryString.substring(DISABLED_TAG.length());
                }
                CommandSessionImportEntry entry = (parts = entryString.split("=")).length == 1 ? new CommandSessionImportEntry(parts[0], "", true) : new CommandSessionImportEntry(parts[1], parts[0], true);
                entry.disabled = disabled;
                result.add(entry);
            }
            ++n2;
        }
        return result;
    }

    private void writeImportPreferences(ArrayList<CommandSessionImportEntry> entries) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (CommandSessionImportEntry entry : entries) {
            if (!entry.persistent) continue;
            if (first) {
                first = false;
            } else {
                b.append(SEPARATOR);
            }
            if (entry.disabled) {
                b.append(DISABLED_TAG);
            }
            if (!entry.localName.isEmpty()) {
                b.append(entry.localName);
                b.append("=");
            }
            b.append(entry.moduleName);
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        store.setValue(IMPORTS, b.toString());
    }

    private ArrayList<CommandSessionImportEntry> getCurrentImports() {
        return this.console.getSession().getImportEntries();
    }

    private void setCurrentImports(ArrayList<CommandSessionImportEntry> entries) {
        this.console.getSession().setImportEntries(entries);
    }

    private void scheduleSetCurrentImports(ArrayList<CommandSessionImportEntry> entries) {
        boolean scheduled;
        boolean bl = scheduled = this.assignedImports.getAndSet(entries) != null;
        if (!scheduled) {
            this.setImportsJob.schedule();
        }
    }

    private void manageImports() {
        ManageImportsDialog dialog = new ManageImportsDialog(this.getSite().getShell(), this.getCurrentImports());
        if (dialog.open() == 0) {
            this.writeImportPreferences(dialog.getImports());
            this.scheduleSetCurrentImports(dialog.getImports());
        }
    }

    private void sclTestDialog() {
        List tests = TestUtils.getTests();
        SCLTestsDialog dialog = new SCLTestsDialog(this.getSite().getShell(), tests, true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                TestRunnable test = (TestRunnable)result;
                try {
                    this.console.execute("import \"Commands/Tests\"");
                    this.console.execute("runByName \"" + test.getName() + "\"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private void setRefreshAutomatically(boolean refreshAutomatically, boolean refreshAlso) {
        this.refreshAutomatically = refreshAutomatically;
        if (this.refreshAutomaticallyItem != null) {
            this.refreshAutomaticallyItem.setSelection(refreshAutomatically);
        }
        this.store.setValue(REFRESH_AUTOMATICALLY, refreshAutomatically);
        if (refreshAutomatically) {
            this.console.getSession().setDependenciesListener(this.dependencyListener);
            if (refreshAlso) {
                this.console.getSession().updateRuntimeEnvironment(true);
            }
        } else {
            this.console.getSession().setDependenciesListener(null);
            this.dependencyListener.stopListening();
        }
    }

    public void createPartControl(Composite parent) {
        this.store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        this.store.setDefault(REFRESH_AUTOMATICALLY, true);
        this.console = new SCLConsole(parent, 0);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        final Action interruptAction = ConsoleActions.createInterruptAction(this.console);
        toolBarManager.add((IAction)interruptAction);
        final Action clearAction = ConsoleActions.createClearAction(this.console);
        toolBarManager.add((IAction)clearAction);
        this.console.addListener(new SCLConsoleListener(){

            public void startedExecution() {
                interruptAction.setEnabled(true);
            }

            public void finishedExecution() {
                interruptAction.setEnabled(false);
            }

            public void consoleIsNotEmptyAnymore() {
                clearAction.setEnabled(true);
            }
        });
        toolBarManager.add((IAction)new Action(Messages.SCLConsoleView_RefreshModules, 4){
            {
                this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)SCLConsoleView.PLUGIN_ID, (String)"icons/arrow_refresh.png"));
                this.setMenuCreator(new IMenuCreator(){
                    Menu menu;

                    public Menu getMenu(Menu parent) {
                        throw new UnsupportedOperationException();
                    }

                    public Menu getMenu(Control parent) {
                        if (this.menu == null) {
                            this.menu = new Menu(parent);
                            (this).SCLConsoleView.this.refreshAutomaticallyItem = new MenuItem(this.menu, 32);
                            (this).SCLConsoleView.this.refreshAutomaticallyItem.setText(Messages.SCLConsoleView_RefreshAutomatically);
                            (this).SCLConsoleView.this.refreshAutomaticallyItem.setSelection((this).SCLConsoleView.this.refreshAutomatically);
                            (this).SCLConsoleView.this.refreshAutomaticallyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    SCLConsoleView.this.setRefreshAutomatically(!((this).this).SCLConsoleView.this.refreshAutomatically, true);
                                }
                            });
                        }
                        return this.menu;
                    }

                    public void dispose() {
                        if (this.menu != null) {
                            this.menu.dispose();
                        }
                    }
                });
            }

            public void run() {
                SCLConsoleView.this.console.getSession().getModuleRepository().getSourceRepository().checkUpdates();
                SCLConsoleView.this.console.getSession().updateRuntimeEnvironment(true);
                SCLConsoleView.this.console.appendOutput(Messages.SCLConsoleView_RefreshCompleted, SCLConsoleView.this.console.greenColor, null);
            }
        });
        toolBarManager.add((IAction)new Action(Messages.SCLConsoleView_ManageImports, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/configure_imports.png")){

            public void run() {
                SCLConsoleView.this.manageImports();
            }
        });
        if (Platform.inDevelopmentMode()) {
            toolBarManager.add((IAction)new Action(Messages.SCLConsoleView_RunTests, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/run_tests.png")){

                public void run() {
                    SCLConsoleView.this.sclTestDialog();
                }
            });
        }
        toolBarManager.update(true);
        this.setRefreshAutomatically(this.store.getBoolean(REFRESH_AUTOMATICALLY), false);
        this.addScriptDropSupport(this.console);
        this.scheduleSetCurrentImports(this.readImportPreferences());
    }

    private void addScriptDropSupport(SCLConsole console) {
        DropTarget target = new DropTarget((Control)console.getOutputWidget(), 23);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new ScriptRunningDropTarget());
    }

    public void setFocus() {
        this.console.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.console.dispose();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandSession.class) {
            return (T)this.console.getSession();
        }
        if (adapter == SCLReportingHandler.class) {
            return (T)this.console.getHandler();
        }
        return (T)super.getAdapter(adapter);
    }

    private class ScriptRunningDropTarget
    extends DropTargetAdapter {
        private ScriptRunningDropTarget() {
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 4;
            }
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 4;
            }
        }

        public void drop(DropTargetEvent event) {
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Object[] files = (String[])((String[])event.data).clone();
                Arrays.sort(files);
                Object[] objectArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    Path p = Paths.get((String)file, new String[0]).toAbsolutePath();
                    if (this.isScriptFile(p)) {
                        SCLConsoleView.this.console.execute("runFromFile \"" + p.toString().replace('\\', '/') + "\"");
                    }
                    ++n2;
                }
            }
        }

        private boolean isScriptFile(Path p) {
            return Files.isRegularFile(p, new LinkOption[0]);
        }
    }

    private class SetImportsJob
    extends Job {
        public SetImportsJob() {
            super(Messages.SCLConsoleView_SetImports);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ArrayList entries = SCLConsoleView.this.assignedImports.getAndSet(null);
                if (entries != null) {
                    SCLConsoleView.this.setCurrentImports(entries);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        public boolean shouldSchedule() {
            return PlatformUI.isWorkbenchRunning();
        }

        public boolean shouldRun() {
            return PlatformUI.isWorkbenchRunning();
        }
    }
}

