package org.simantics.scl.runtime.either;

public class Left implements Either {
    public final Object value;

    public Left(Object value) {
        this.value = value;
    }
    
    @Override
    public String toString() {
        return "Left " + value;
    }
    
    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null || obj.getClass() != getClass())
            return false;
        Left other = (Left)obj;
        return value == null ? other.value == null : value.equals(other.value);
    }
    
    @Override
    public int hashCode() {
        return 31 * (value == null ? 0 : value.hashCode()) + 13532;
    }
}
