package org.simantics.scl.reflection.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator implements BundleActivator {

    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;  
    
    private static Activator instance;
    
    @Override
    public void start(BundleContext context) throws Exception {
        this.context = context;
        instance = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.context = null;
    }
    
    public BundleContext getContext() {
        return context;
    }
    
    public static Activator getInstance() {
        return instance;
    }
        
    public static void logError(String description, Exception e) {
        LOGGER.error(description);
        if(e != null)
            e.printStackTrace();
        Bundle bundle = getInstance().getContext().getBundle();
        ILog log = Platform.getLog(bundle);
        log.log(new Status(Status.ERROR, bundle.getSymbolicName(), description, e));
    }
    
    public static void logError(String description) {
        logError(description, null);
    }

}
