package org.simantics.scl.reflection.functions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.simantics.scl.runtime.function.FunctionImplN;

public class ClassMethodFunction extends FunctionImplN {
    Method method;

    public ClassMethodFunction(Method method) {
        super(method.getParameterTypes().length);
        this.method = method;
    }
    
    public Method getMethod() {
        return method;
    }

    @Override
    public Object doApply(Object... ps) {
        try {
            return method.invoke(null, ps);
        } catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
    
    @Override
    public String toString() {
        return method.getName();
    }
}
