package org.simantics.scl.expressions;

/**
 * Describes an environment for evaluating expressions.
 * The description includes the names and types of the
 * environment variables, but not necessarily the values.
 * The values are obtained using the ContextualValues
 * given by successfully resolved variables. 
 * @author Hannu Niemist&ouml;
 * @param <Context>
 */
public interface EnvironmentDescription<Context> {
    /**
     * Tries to resolve an environment variable
     * with a given name. Returns <code>null</code>
     * if there is no such variable. If variable is
     * found, returns ContextualValue that can be
     * used to obtain the value of the environment 
     * variable with a suitable context.
     * @param name
     * @return
     */
    ContextualValue<Context> resolve(String name);
}
