/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TForAllAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TForAll
extends Type {
    public final TVar var;
    public Type type;

    TForAll(TVar var, Type type) {
        if (var == null || type == null) {
            throw new NullPointerException();
        }
        this.var = var;
        this.type = type;
    }

    private TForAll create(Type type) {
        if (type == this.type) {
            return this;
        }
        return new TForAll(this.var, type);
    }

    @Override
    public TForAll replace(TVar var, Type replacement) {
        if (var == this.var) {
            if (replacement instanceof TVar) {
                return new TForAll((TVar)replacement, this.type.replace(var, replacement));
            }
            throw new IllegalStateException("Tried to replace a variable that is not free in the type.");
        }
        return this.create(this.type.replace(var, replacement));
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(context.getName(this.var));
        Type cur = Types.canonical(this.type);
        while (cur instanceof TForAll) {
            TForAll forAll = (TForAll)cur;
            vars.add(context.getName(forAll.var));
            cur = Types.canonical(forAll.type);
        }
        return new TForAllAst(vars.toArray(new String[vars.size()]), cur.toTypeAst(context));
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-231468493);
        TObjectIntHashMap<TVar> varHashCode = context.createVarHashCode();
        varHashCode.put((Object)this.var, varHashCode.size());
        this.type.updateHashCode(context);
        varHashCode.remove((Object)this.var);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.type.collectFreeVars(vars);
        vars.remove(this.var);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.type.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.type.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.type.collectEffectMetaVars(vars);
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.type.contains(other);
    }

    @Override
    public Type convertMetaVarsToVars() {
        Type newType = this.type.convertMetaVarsToVars();
        if (newType == this.type) {
            return this;
        }
        return new TForAll(this.var, this.type);
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        this.type.checkKind(context, Kinds.STAR);
        return Kinds.STAR;
    }

    @Override
    public boolean containsMetaVars() {
        return this.type.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.type.toName(context, b);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.type.addPolarity(polarity);
    }

    @Override
    public Type head() {
        return this;
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        return new TMetaVar(Kinds.STAR);
    }

    @Override
    public int hashCode(int hash) {
        int count = 1;
        Type t = Types.canonical(this.type);
        while (t instanceof TForAll) {
            t = Types.canonical(((TForAll)t).type);
            ++count;
        }
        TVar[] boundVars = new TVar[count];
        boundVars[0] = this.var;
        TForAll t2 = this;
        int i = 1;
        while (i < count) {
            t2 = (TForAll)Types.canonical(t2.type);
            boundVars[i] = t2.var;
            ++i;
        }
        i = 0;
        while (i < count) {
            hash = HashCodeUtils.updateWithPreprocessedValue(hash, FORALL_HASH);
            ++i;
        }
        return t2.type.hashCode(hash, boundVars);
    }

    @Override
    public int hashCode(int hash, TVar[] oldBoundVars) {
        int count = 1;
        Type t = Types.canonical(this.type);
        while (t instanceof TForAll) {
            t = Types.canonical(((TForAll)t).type);
            ++count;
        }
        TVar[] boundVars = Arrays.copyOf(oldBoundVars, oldBoundVars.length + count);
        boundVars[oldBoundVars.length] = this.var;
        TForAll t2 = this;
        int i = 1;
        while (i < count) {
            t2 = (TForAll)Types.canonical(t2.type);
            boundVars[oldBoundVars.length + i] = t2.var;
            ++i;
        }
        i = 0;
        while (i < count) {
            hash = HashCodeUtils.updateWithPreprocessedValue(hash, FORALL_HASH);
            ++i;
        }
        return t2.type.hashCode(hash, boundVars);
    }

    @Override
    public int skeletonHashCode(int hash) {
        int count = 1;
        Type t = Types.canonical(this.type);
        while (t instanceof TForAll) {
            t = Types.canonical(((TForAll)t).type);
            ++count;
        }
        TVar[] boundVars = new TVar[count];
        boundVars[0] = this.var;
        TForAll t2 = this;
        int i = 1;
        while (i < count) {
            t2 = (TForAll)Types.canonical(t2.type);
            boundVars[i] = t2.var;
            ++i;
        }
        i = 0;
        while (i < count) {
            hash = HashCodeUtils.updateWithPreprocessedValue(hash, FORALL_HASH);
            ++i;
        }
        return t2.type.skeletonHashCode(hash, boundVars);
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] oldBoundVars) {
        int count = 1;
        Type t = Types.canonical(this.type);
        while (t instanceof TForAll) {
            t = Types.canonical(((TForAll)t).type);
            ++count;
        }
        TVar[] boundVars = Arrays.copyOf(oldBoundVars, oldBoundVars.length + count);
        boundVars[oldBoundVars.length] = this.var;
        TForAll t2 = this;
        int i = 1;
        while (i < count) {
            t2 = (TForAll)Types.canonical(t2.type);
            boundVars[oldBoundVars.length + i] = t2.var;
            ++i;
        }
        i = 0;
        while (i < count) {
            hash = HashCodeUtils.updateWithPreprocessedValue(hash, FORALL_HASH);
            ++i;
        }
        return t2.type.skeletonHashCode(hash, boundVars);
    }

    public Type getCanonicalType() {
        if (this.type instanceof TMetaVar) {
            this.type = this.type.canonical();
        }
        return this.type;
    }

    @Override
    public boolean equalsCanonical(Type other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(TForAll.class)) {
            return false;
        }
        TForAll forAll = (TForAll)other;
        return this.getCanonicalType().equalsCanonical(forAll.getCanonicalType().replace(forAll.var, this.var));
    }

    @Override
    public Kind getKind(Environment context) {
        return Kinds.STAR;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return new Type[]{Skeletons.canonicalSkeleton(this.type)};
    }
}

