/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ClassModuleSource;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleBrowsingUtil;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class ClassModuleSourceRepository
implements ModuleSourceRepository {
    private final Class<?> clazz;
    private final String path;
    private final ClassLoader classLoader;
    private final THashSet<String> modules = new THashSet();

    public ClassModuleSourceRepository(Class<?> clazz, ClassLoader classLoader, String path) throws IOException {
        this.clazz = clazz;
        this.path = path;
        this.classLoader = classLoader;
        URL url = clazz.getResource(path);
        if (url == null) {
            throw new IOException("Didn't find a folder " + path + " relative to the class " + clazz.getName() + ".");
        }
        ModuleBrowsingUtil.collectModuleSourcesAt(this.modules, url);
    }

    @Override
    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        if (!this.modules.contains((Object)moduleName)) {
            return null;
        }
        return new ClassModuleSource(moduleName, this.clazz, this.classLoader, String.valueOf(this.path) + "/" + moduleName + ".scl", this.getBuiltinImports());
    }

    @Override
    public Collection<String> getModuleNames() {
        return this.modules;
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        this.modules.forEach(procedure);
    }

    protected ImportDeclaration[] getBuiltinImports() {
        return ClassModuleSource.DEFAULT_IMPORTS;
    }
}

