/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.types.Type;

public class CodeBuilderUtils {
    public static void makeRecord(ClassBuilder classBuilder, String recordName, int fieldModifiers, String fieldNamePrefix, TypeDesc[] types, boolean generateEqualsAndHashCode) {
        int i = 0;
        while (i < types.length) {
            if (!types[i].equals(TypeDesc.VOID)) {
                classBuilder.addField(fieldModifiers, String.valueOf(fieldNamePrefix) + i, types[i]);
            }
            ++i;
        }
        MethodBuilderBase mb = classBuilder.addConstructorBase(types.length == 0 ? 2 : 1, JavaTypeTranslator.filterVoid(types));
        mb.loadThis();
        mb.invokeConstructor(classBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
        if (types.length == 0) {
            TypeDesc thisClass = classBuilder.getType();
            classBuilder.addField(25, "INSTANCE", thisClass);
            MethodBuilderBase inimb = classBuilder.addInitializerBase();
            inimb.newObject(thisClass);
            inimb.dup();
            inimb.invokeConstructor(classBuilder.getClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
            inimb.storeStaticField(classBuilder.getClassName(), "INSTANCE", thisClass);
            inimb.returnVoid();
            inimb.finish();
        } else {
            int i2 = 0;
            int j = 0;
            while (i2 < types.length) {
                if (!types[i2].equals(TypeDesc.VOID)) {
                    mb.loadThis();
                    mb.loadLocal(mb.getParameter(j++));
                    mb.storeField(classBuilder.getClassName(), String.valueOf(fieldNamePrefix) + i2, types[i2]);
                }
                ++i2;
            }
        }
        mb.returnVoid();
        mb.finish();
        MethodBuilderBase tsmb = classBuilder.addMethodBase(1, "toString", TypeDesc.STRING, Constants.EMPTY_TYPEDESC_ARRAY);
        if (types.length > 0) {
            tsmb.newObject(TypeDesc.forClass(StringBuilder.class));
            tsmb.dup();
            tsmb.invokeConstructor("java/lang/StringBuilder", Constants.EMPTY_TYPEDESC_ARRAY);
            tsmb.loadConstant("(" + recordName);
            CodeBuilderUtils.StringBuilder_appendString(tsmb);
            int i3 = 0;
            while (i3 < types.length) {
                if (types[i3].equals(TypeDesc.VOID)) {
                    tsmb.loadConstant(" ()");
                    CodeBuilderUtils.StringBuilder_appendString(tsmb);
                } else {
                    tsmb.loadConstant(" ");
                    CodeBuilderUtils.StringBuilder_appendString(tsmb);
                    tsmb.loadThis();
                    tsmb.loadField(classBuilder.getClassName(), String.valueOf(fieldNamePrefix) + i3, types[i3]);
                    CodeBuilderUtils.StringBuilder_appendObject(tsmb, types[i3]);
                }
                ++i3;
            }
            tsmb.loadConstant(")");
            CodeBuilderUtils.StringBuilder_appendString(tsmb);
            tsmb.invokeVirtual("java/lang/StringBuilder", "toString", TypeDesc.STRING, Constants.EMPTY_TYPEDESC_ARRAY);
        } else {
            tsmb.loadConstant(recordName);
        }
        tsmb.returnValue(TypeDesc.STRING);
        tsmb.finish();
        if (generateEqualsAndHashCode) {
            CodeBuilderUtils.implementHashCodeAndEquals(classBuilder, recordName, fieldNamePrefix, types);
        }
    }

    public static void implementHashCodeAndEquals(ClassBuilder classBuilder, String recordName, String fieldNamePrefix, TypeDesc[] types) {
        TypeDesc CLASS = TypeDesc.forClass(Class.class);
        MethodBuilderBase tsmb = classBuilder.addMethodBase(1, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        LocalVariable parameter = tsmb.getParameter(0);
        Label success = tsmb.createLabel();
        Label failure = tsmb.createLabel();
        tsmb.loadThis();
        tsmb.loadLocal(parameter);
        tsmb.ifComparisonBranch(success, "==", TypeDesc.OBJECT);
        tsmb.loadLocal(parameter);
        tsmb.ifNullBranch(failure, true);
        tsmb.loadLocal(parameter);
        tsmb.invokeVirtual("java/lang/Object", "getClass", CLASS, Constants.EMPTY_TYPEDESC_ARRAY);
        tsmb.loadThis();
        tsmb.invokeVirtual("java/lang/Object", "getClass", CLASS, Constants.EMPTY_TYPEDESC_ARRAY);
        tsmb.ifComparisonBranch(failure, "!=", CLASS);
        tsmb.loadLocal(parameter);
        tsmb.checkCast(classBuilder.getType());
        LocalVariable other = tsmb.createLocalVariable("other", classBuilder.getType());
        tsmb.storeLocal(other);
        int i = 0;
        while (i < types.length) {
            TypeDesc type = types[i];
            if (!type.equals(TypeDesc.VOID)) {
                tsmb.loadThis();
                tsmb.loadField(classBuilder.getClassName(), String.valueOf(fieldNamePrefix) + i, type);
                tsmb.loadLocal(other);
                tsmb.loadField(classBuilder.getClassName(), String.valueOf(fieldNamePrefix) + i, type);
                CodeBuilderUtils.equals(tsmb, type, failure);
            }
            ++i;
        }
        tsmb.setLocation(success);
        tsmb.loadConstant(true);
        tsmb.returnValue(TypeDesc.BOOLEAN);
        tsmb.setLocation(failure);
        tsmb.loadConstant(false);
        tsmb.returnValue(TypeDesc.BOOLEAN);
        tsmb.finish();
        MethodBuilderBase tsmb2 = classBuilder.addMethodBase(1, "hashCode", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
        tsmb2.loadConstant(recordName.hashCode());
        int i2 = 0;
        while (i2 < types.length) {
            TypeDesc type = types[i2];
            if (!type.equals(TypeDesc.VOID)) {
                tsmb2.loadConstant(31);
                tsmb2.math(104);
                tsmb2.loadThis();
                tsmb2.loadField(classBuilder.getClassName(), String.valueOf(fieldNamePrefix) + i2, type);
                CodeBuilderUtils.hashCode(tsmb2, type);
                tsmb2.math(96);
            }
            ++i2;
        }
        tsmb2.returnValue(TypeDesc.INT);
        tsmb2.finish();
    }

    public static void equals(MethodBuilderBase mb, TypeDesc typeDesc, Label failure) {
        if (typeDesc.isPrimitive()) {
            mb.ifComparisonBranch(failure, "!=", typeDesc);
        } else {
            Label isNull = mb.createLabel();
            Label finished = mb.createLabel();
            mb.swap();
            mb.dup();
            mb.ifNullBranch(isNull, true);
            mb.swap();
            mb.invokeVirtual("java/lang/Object", "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
            mb.ifZeroComparisonBranch(failure, "==");
            mb.branch(finished);
            mb.setLocation(isNull);
            mb.pop();
            mb.ifNullBranch(failure, false);
            mb.setLocation(finished);
        }
    }

    public static void hashCode(MethodBuilderBase mb, TypeDesc typeDesc) {
        switch (typeDesc.getTypeCode()) {
            case 10: {
                break;
            }
            case 0: {
                Label isNull = mb.createLabel();
                Label finished = mb.createLabel();
                mb.dup();
                mb.ifNullBranch(isNull, true);
                mb.invokeVirtual("java/lang/Object", "hashCode", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
                mb.branch(finished);
                mb.setLocation(isNull);
                mb.pop();
                mb.loadConstant(0);
                mb.setLocation(finished);
                break;
            }
            case 7: {
                mb.invokeStatic("java/lang/Double", "doubleToLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
            }
            case 11: {
                mb.dup2();
                mb.loadConstant(32);
                mb.math(123);
                mb.math(131);
                mb.convert(TypeDesc.LONG, TypeDesc.INT);
                break;
            }
            case 6: {
                mb.invokeStatic("java/lang/Float", "floatToIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
                break;
            }
            default: {
                mb.convert(typeDesc, TypeDesc.INT);
            }
        }
    }

    public static void constructRecord(TypeDesc clazz, MethodBuilder mb, Type[] parameterTypes, Val ... parameters) {
        if (parameters.length == 0) {
            mb.loadStaticField(clazz, "INSTANCE", clazz);
        } else {
            mb.newObject(clazz);
            mb.dup();
            int i = 0;
            while (i < parameters.length) {
                mb.push(parameters[i], parameterTypes[i]);
                ++i;
            }
            JavaTypeTranslator tt = mb.moduleBuilder.getJavaTypeTranslator();
            mb.invokeConstructor(clazz, JavaTypeTranslator.filterVoid(tt.toTypeDescs(Arrays.copyOf(parameterTypes, parameters.length))));
        }
    }

    public static void StringBuilder_appendString(MethodBuilderBase mb) {
        mb.invokeVirtual("java/lang/StringBuilder", "append", TypeDesc.forClass("java.lang.StringBuilder"), new TypeDesc[]{TypeDesc.STRING});
    }

    public static void StringBuilder_appendObject(MethodBuilderBase mb, TypeDesc type) {
        if (!type.isPrimitive() && type != TypeDesc.STRING) {
            type = TypeDesc.OBJECT;
        }
        mb.invokeVirtual("java/lang/StringBuilder", "append", TypeDesc.forClass("java.lang.StringBuilder"), new TypeDesc[]{type});
    }
}

