/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.exits;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.exceptions.MatchingException;

public class Throw
extends SSAExit {
    public static final TypeDesc RuntimeException = TypeDesc.forClass(RuntimeException.class);
    public static final TypeDesc MatchingException = TypeDesc.forClass(MatchingException.class);
    TypeDesc exceptionClass;
    String description;

    public Throw(int lineNumber, TypeDesc exceptionClass, String description) {
        super(lineNumber);
        this.exceptionClass = exceptionClass;
        this.description = description;
    }

    @Override
    public void toString(PrintingContext context) {
        context.append("throw\n");
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        mb.lineNumber(this.lineNumber);
        mb.newObject(this.exceptionClass);
        mb.dup();
        if (this.description == null) {
            mb.invokeConstructor(this.exceptionClass, Constants.EMPTY_TYPEDESC_ARRAY);
        } else {
            mb.loadConstant(this.description);
            mb.invokeConstructor(this.exceptionClass, new TypeDesc[]{TypeDesc.STRING});
        }
        mb.throwObject();
    }

    @Override
    public void validate(SSAValidationContext context) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public SSAExit copy(CopyContext context) {
        return new Throw(this.lineNumber, this.exceptionClass, this.description);
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        return proxy;
    }

    @Override
    public SSABlock[] getSuccessors() {
        return SSABlock.EMPTY_ARRAY;
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
    }

    @Override
    public void cleanup() {
    }
}

