/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import java.lang.reflect.Field;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.types.Type;

public class JavaStaticField
extends Constant {
    String className;
    String fieldName;
    TypeDesc fieldType;
    Type effect;
    int constructorTag;

    public JavaStaticField(String className, String fieldName, Type effect, TypeDesc fieldType, Type type, int constructorTag) {
        super(type);
        this.className = className;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.effect = effect;
        this.constructorTag = constructorTag;
    }

    public JavaStaticField(String className, String fieldName, Type type, int constructorTag) {
        this(className, fieldName, null, null, type, constructorTag);
    }

    @Override
    public void push(MethodBuilder mb) {
        if (this.fieldType == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.fieldType = tt.toTypeDesc(this.getType());
        }
        mb.loadStaticField(this.className, this.fieldName, this.fieldType);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        MutableClassLoader classLoader = classBuilder.classLoader;
        try {
            Class<?> clazz = classLoader.loadClass(this.className.replace('/', '.'));
            Field field = clazz.getDeclaredField(this.fieldName);
            return field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
        catch (SecurityException e) {
            throw new InternalCompilerError(e);
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerError(e);
        }
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        this.push(mb);
        mb.push(parameter, this.getType());
        mb.invokeVirtual(TypeDesc.OBJECT, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        mb.ifZeroComparisonBranch(failure, "==");
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return this.constructorTag;
    }

    public String toString() {
        return "JavaStaticField(" + this.className + "." + this.fieldName + ")";
    }
}

