/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.commands;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.StringModuleSource;
import org.simantics.scl.compiler.source.repository.MapModuleSourceRepository;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSessionWithModules {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSessionWithModules.class);
    private MapModuleSourceRepository localModuleSourceRepository = new MapModuleSourceRepository();
    private ModuleRepository moduleRepository;
    private CommandSession commandSession;
    private static final SCLReportingHandler DEFAULT_REPORTING_HANDLER = new AbstractSCLReportingHandler(){

        public void print(String text) {
            LOGGER.info(text);
        }
    };

    public CommandSessionWithModules(ModuleRepository parentRepository) {
        this.moduleRepository = new ModuleRepository(parentRepository, this.localModuleSourceRepository);
        this.commandSession = new CommandSession(this.moduleRepository, DEFAULT_REPORTING_HANDLER);
        this.commandSession.setDependenciesListener(new UpdateListener(){

            @Override
            public void notifyAboutUpdate() {
                CommandSessionWithModules.this.commandSession.updateRuntimeEnvironment(true);
            }
        });
    }

    public CommandSession getCommandSession() {
        return this.commandSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putModule(String moduleName, String moduleText) {
        StringModuleSource moduleSource = new StringModuleSource(moduleName, moduleText);
        MapModuleSourceRepository mapModuleSourceRepository = this.localModuleSourceRepository;
        synchronized (mapModuleSourceRepository) {
            this.localModuleSourceRepository.addModuleDescriptor(moduleSource);
        }
        Failable<Module> module = this.moduleRepository.getModule(moduleName);
        if (module.didSucceed()) {
            return null;
        }
        return ((Failure)module).toString(moduleText);
    }

    public void runCommands(Reader commandReader, final Writer responseWriter) {
        AbstractSCLReportingHandler handler = new AbstractSCLReportingHandler(){

            public void printCommand(String command) {
            }

            public void print(String text) {
                try {
                    responseWriter.write(String.valueOf(text) + "\n");
                    responseWriter.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Writing reponse failed.", (Throwable)e);
                }
            }
        };
        this.commandSession.execute(commandReader, (SCLReportingHandler)handler);
    }
}

