package org.simantics.scl.compiler.types.kinds;

import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

/**
 * This class represent a type kind constant with a given name.
 * 
 * The {@link #contains(KMetaVar)} method always returns false, as kind constants do not
 * include any meta-variable-references.
 */
public class KCon extends Kind {
    public final String name;

    KCon(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }
    
    @Override
    protected void toStringPar(TypeUnparsingContext tuc, StringBuilder b) {
        b.append(name);
    }

    @Override
    public boolean contains(KMetaVar var) {
        return false;
    }    
}
