package org.simantics.scl.compiler.top;

import java.lang.reflect.Field;

import org.simantics.scl.compiler.internal.codegen.writer.ExternalConstant;

public class StandardModuleInitializer implements ModuleInitializer {
    private final String moduleClassName; 
    private final ExternalConstant[] externalConstants;
    
    private StandardModuleInitializer(String moduleClassName,
            ExternalConstant[] externalConstants) {
        this.moduleClassName = moduleClassName;
        this.externalConstants = externalConstants;
    }

    @Override
    public void initializeModule(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass(moduleClassName.replace('/', '.'));
        for(ExternalConstant ec : externalConstants) {
            Field field = clazz.getField(ec.fieldName);
            field.set(null, ec.value);
        }
    }
    
    public static ModuleInitializer create(String moduleClassName, ExternalConstant[] externalConstants) {
        if(externalConstants.length == 0)
            return null;
        else
            return new StandardModuleInitializer(moduleClassName, externalConstants);
    }
}
