package org.simantics.scl.compiler.source.repository;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ClassModuleSource;
import org.simantics.scl.compiler.source.FileModuleSource;
import org.simantics.scl.compiler.source.ModuleSource;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;

public class FileModuleSourceRepository implements ModuleSourceRepository {
    
    private final File path;
    private final ClassLoader classLoader;
    private final THashSet<String> modules = new THashSet<String>();
    
    public FileModuleSourceRepository(File path, ClassLoader classLoader) throws IOException {
        this.path = path;
        this.classLoader = classLoader;
        ModuleBrowsingUtil.collectModuleSourcesAt(modules, path);
    }

    @Override
    public ModuleSource getModuleSource(String moduleName,
            UpdateListener listener) {
        if(!modules.contains(moduleName))
            return null;
        return new FileModuleSource(moduleName, classLoader, new File(path, moduleName + ".scl"), getBuiltinImports());
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        modules.forEach(procedure);
    }
    
    @Override
    public Collection<String> getModuleNames() {
        return modules;
    }
    
    protected ImportDeclaration[] getBuiltinImports() {
        return ClassModuleSource.DEFAULT_IMPORTS;
    }
}
