package org.simantics.scl.compiler.source.repository;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;

import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ClassModuleSource;
import org.simantics.scl.compiler.source.ModuleSource;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;

public class ClassModuleSourceRepository implements ModuleSourceRepository {
    
    private final Class<?> clazz;
    private final String path;
    private final ClassLoader classLoader;
    private final THashSet<String> modules = new THashSet<String>();
    
    public ClassModuleSourceRepository(Class<?> clazz, ClassLoader classLoader, String path) throws IOException {
        this.clazz = clazz;
        this.path = path;
        this.classLoader = classLoader;
        URL url = clazz.getResource(path);
        if(url == null)
            throw new IOException("Didn't find a folder " + path + " relative to the class " + clazz.getName() + ".");
        ModuleBrowsingUtil.collectModuleSourcesAt(modules, url);
    }

    @Override
    public ModuleSource getModuleSource(String moduleName,
            UpdateListener listener) {
        if(!modules.contains(moduleName))
            return null;
        return new ClassModuleSource(moduleName, clazz, classLoader, path + "/" + moduleName + ".scl", getBuiltinImports());
    }

    @Override
    public Collection<String> getModuleNames() {
        return modules;
    }
    
    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        modules.forEach(procedure);
    }
    
    protected ImportDeclaration[] getBuiltinImports() {
        return ClassModuleSource.DEFAULT_IMPORTS;
    }
}
