package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class TConAst extends TypeAst {

    public final String name;
    
    public TConAst(String name) {
        this.name = name;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append(name);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        char c = name.charAt(0);
        if(c == '(') {
            for(int i=1;i<name.length()-1;++i)
                if(name.charAt(i) != ',') {
                    return context.resolveTypeConstructor(name.substring(1, name.length()-1));
                }
            return Types.con(Types.BUILTIN, name);
        }
        else {
            int p = name.lastIndexOf('.');
            if(p == -1)
                return context.resolveTypeConstructor(name);
            else
                return context.resolveTypeConstructor(name.substring(0, p), name.substring(p+1));
        }
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
    
}
