package org.simantics.scl.compiler.internal.types;

/**
 * Utils for computing 32-bit Murmur3 hash function
 */
public class HashCodeUtils {
    
    private static final int C1 = 0xcc9e2d51;
    private static final int C2 = 0x1b873593;
    private static final int R1 = 15;
    private static final int R2 = 13;
    private static final int M = 5;
    private static final int N = 0xe6546b64;
    
    public static final int SEED = 0;
    
    public static int update(int hash, int value) {
        value *= C1;
        value = Integer.rotateLeft(value, R1);
        value *= C2;
        
        hash ^= value;
        return Integer.rotateLeft(hash, R2) * M + N;
    }
    
    public static int preprocessValue(int value) {
        value *= C1;
        value = Integer.rotateLeft(value, R1);
        value *= C2;
        return value;
    }
    
    public static int updateWithPreprocessedValue(int hash, int preprocessedValue) {
        hash ^= preprocessedValue;
        return Integer.rotateLeft(hash, R2) * M + N;
    }
    
    public static int finalize(int hash) {
        hash ^= hash >> 16;
        hash *= 0x85ebca6b;
        hash ^= hash >> 13;
        hash *= 0xc2b2ae35;
        hash ^= hash >> 16;
        return hash;
    }
}
