package org.simantics.scl.compiler.internal.parsing.types;

import java.util.List;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;



public class TTupleAst extends TypeAst {
    public final TypeAst[] components;
    
    public TTupleAst(TypeAst ... components) {
        this.components = components;
    }
    
    public TTupleAst(List<TypeAst> components) {
        this(components.toArray(new TypeAst[components.size()]));
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('(');
        for(int i=0;i<components.length;++i) {
            if(i > 0)
                b.append(", ");
            components[i].toString(b);
        }
        b.append(')');
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        if(components.length == 1) {
            return components[0].toType(context, expectedKind);
        }
        else {
            context.unify(location, Kinds.STAR, expectedKind);
            return Types.tuple(toTypes(context, components));
        }
    }
    
    @Override
    public Type toType(TypeElaborationContext context) {
        if(components.length == 1) {
            return components[0].toType(context);
        }
        else {
            return Types.tuple(toTypes(context, components));
        }
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        for(TypeAst component : components)
            component.collectReferences(typeNameMap, set);
    }
}
