package org.simantics.scl.compiler.internal.interpreted;


public class ISeq implements IExpression {
    private final IExpression value;
    private final IExpression in;

    public ISeq(IExpression value, IExpression in) {
        this.value = value;
        this.in = in;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        value.execute(variableBindings);
        return in.execute(variableBindings);
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        b.append(value);
        b.append(" ; ");
        b.append(in);
        b.append(')');
        return b.toString();
    }
}
