package org.simantics.scl.compiler.internal.deriving;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.THashMap;

public class InstanceDerivers {
    private static final THashMap<TCon, InstanceDeriver> MAP = 
            new THashMap<TCon, InstanceDeriver>();
    
    static {
        MAP.put(Types.IO, new IODeriver());
        MAP.put(Types.ORD, new OrdDeriver());
        MAP.put(Types.SHOW, new ShowDeriver());
        MAP.put(Names.Json_Json, new JsonDeriver());
    }
    
    public static InstanceDeriver get(TCon typeClass) {
        return MAP.get(typeClass);
    }
}
