package org.simantics.scl.compiler.internal.codegen.utils;

public class NameMangling {

    private static final boolean[] NORMAL_CHAR = new boolean[128];
    private static final char[] REWRITE_CHAR = new char[128];
    private static final char[] INVERSE_REWRITE_CHAR = new char[128];
    private static final char ESCAPE_CHAR = (char)164;
    
    static {
        for(char c='a';c<='z';++c)
            NORMAL_CHAR[c] = true;
        for(char c='A';c<='Z';++c)
            NORMAL_CHAR[c] = true;
        for(char c='0';c<='9';++c)
            NORMAL_CHAR[c] = true;
        NORMAL_CHAR['_'] = true;
        NORMAL_CHAR['-'] = true;
        NORMAL_CHAR['|'] = true;
        NORMAL_CHAR['+'] = true;
        NORMAL_CHAR['?'] = true;
        NORMAL_CHAR['*'] = true;
        NORMAL_CHAR['!'] = true;
        NORMAL_CHAR['@'] = true;
        NORMAL_CHAR[':'] = true;
        NORMAL_CHAR['$'] = true;        
        NORMAL_CHAR['&'] = true;
        NORMAL_CHAR['%'] = true;
        NORMAL_CHAR['='] = true;
        NORMAL_CHAR['#'] = true;
        
        REWRITE_CHAR['/'] = 'd';
        REWRITE_CHAR['>'] = 'g';
        REWRITE_CHAR['<'] = 'l';
        REWRITE_CHAR['.'] = 'p';
        REWRITE_CHAR[';'] = 's';
        
        for(char c=0;c<128;++c) {
            char r = REWRITE_CHAR[c];
            if(r != 0)
                INVERSE_REWRITE_CHAR[r] = c;
        }
            
    }
    
    public static String mangle(String name) {
        int length = name.length();
        for(int i=0;i<length;++i) {
            char c = name.charAt(i);
            if(c >= 128 || !NORMAL_CHAR[c]) {
                StringBuilder b = new StringBuilder(name.substring(0, i));
                boolean normalMode = true;
                for(;i<length;++i) {
                    c = name.charAt(i);
                    if(c < 128 && NORMAL_CHAR[c]) {
                        if(!normalMode) {
                            b.append(ESCAPE_CHAR);
                            normalMode = true;
                        }
                        b.append(c);
                    }
                    else {
                        if(normalMode) {
                            b.append(ESCAPE_CHAR);
                            normalMode = false;
                        }
                        char r = c < 128 ? REWRITE_CHAR[c] : 0;
                        if(r == 0) {
                            b.append((int)c);
                            b.append(ESCAPE_CHAR);
                        }
                        else {
                            b.append(r);
                        }
                    }
                }
                return b.toString();
            }
        }
        return name;
    }
    
    public static String demangle(String name) {
        int length = name.length();
        for(int i=0;i<length;++i) {
            char c = name.charAt(i);
            if(c == ESCAPE_CHAR) {
                StringBuilder b = new StringBuilder(name.substring(0, i));
                boolean normalMode = false;
                for(++i;i<length;++i) {
                    c = name.charAt(i);
                    if(c == ESCAPE_CHAR)
                        normalMode = !normalMode;
                    else if(normalMode)
                        b.append(c);
                    else {
                        if(c >= '0' && c <= '9') {
                            int l = name.substring(i).indexOf(ESCAPE_CHAR);
                            char r = (char)Integer.parseInt(name.substring(i, i+l));
                            i+=l;
                            b.append(r);
                        }
                        else
                            b.append(INVERSE_REWRITE_CHAR[c]);
                    }
                }
                return b.toString();
            }
        }
        return name;
    }
    
    public static void test(String name) {
        String name2 = mangle(name);
        String name3 = demangle(name2);
        System.out.println(name + " -> " + name2 + " -> " + name3);
    }
    
    public static void main(String[] args) {
        test("hello");
        test("hello_world");
        test("++");
        test("$");
        test("{}");
        test("<");
        test("<=");
        test(">");
        test(">=");
        
        for(int i=28;i<256;++i) {
            if(Character.isJavaIdentifierStart(i))
                System.out.print(new String(Character.toChars(i)) + "(" + i + ")");
        }
        System.out.println();
        System.out.println("----------------------------------------------------");
        for(int i=28;i<256;++i) {
            if(Character.isJavaIdentifierPart(i))
                System.out.print(new String(Character.toChars(i)) + "(" + i + ")");
        }
        System.out.println();
    }
    
}
