package org.simantics.scl.compiler.environment;

import java.util.Map;

import org.simantics.scl.compiler.environment.NamespaceImpl.ModuleImport;

import gnu.trove.map.hash.THashMap;

public class NamespaceSpec {
    public final THashMap<String, NamespaceSpec> namespaceMap = new THashMap<String, NamespaceSpec>();
    public final THashMap<String, ModuleImport> moduleMap = new THashMap<String, ModuleImport>();
    
    public Namespace toNamespace() {
        THashMap<String, Namespace> namespaceImplMap = new THashMap<String, Namespace>(namespaceMap.size());
        for(Map.Entry<String, NamespaceSpec> entry : namespaceMap.entrySet())
            namespaceImplMap.put(entry.getKey(), entry.getValue().toNamespace());
        
        return new NamespaceImpl(namespaceImplMap, moduleMap.values().toArray(new ModuleImport[moduleMap.size()]));
    }
    
    public NamespaceSpec getNamespace(String name) {
        NamespaceSpec result = namespaceMap.get(name);
        if(result == null) {
            result = new NamespaceSpec();
            namespaceMap.put(name, result);
        }
        return result;
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        toString(b);
        return b.toString();
    }

    private void toString(StringBuilder b) {
        b.append('[');
        boolean first = true;
        for(String name : moduleMap.keySet()) {
            if(first)
                first = false;
            else
                b.append(", ");
            b.append(name);
        }
        b.append("]{");
        first = true;
        for(Map.Entry<String, NamespaceSpec> entry : namespaceMap.entrySet()) {
            if(first)
                first = false;
            else
                b.append(", ");
            b.append(entry.getKey());
            b.append('=');
            entry.getValue().toString(b);
        }
        b.append('}');
    }
}
