package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class LengthVector extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    private final TCon constructor;  
    
    public LengthVector(TCon constructor) {
        super(new TVar[] {A}, Types.NO_EFFECTS, Types.INTEGER, Types.apply(constructor, A));
        this.constructor = constructor;
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];        
        vector.push(mb);
        
        try {
            Type elementType = Types.canonical(
                    Types.matchApply(constructor, vector.getType()));
            if(elementType instanceof TVar) {
                mb.invokeStatic("java/lang/reflect/Array", "getLength", TypeDesc.INT, 
                        Constants.OBJECTS[1]);
                return Types.INTEGER;
            }
            else {
                mb.arrayLength();
                return Types.INTEGER;
            }
        } catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }   

}
