/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.commands.internal;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.internal.ErrorCommand;
import org.simantics.scl.commands.internal.checker.Checker;
import org.simantics.scl.commands.internal.serialization.CommandSerializer;
import org.simantics.scl.commands.internal.serialization.CommandSerializerFactory;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.utils.logging.TimeLogger;

public class CommandImpl
implements Command {
    String name;
    Function command;
    Type[] parameterTypes;
    CommandSerializer serializer;
    Checker checker;
    private static boolean serializationErrorAlreadySeen = false;

    public CommandImpl(String name, Function command, Type[] parameterTypes, CommandSerializer serializer, Checker checker) {
        this.name = name;
        this.command = command;
        this.parameterTypes = parameterTypes;
        this.serializer = serializer;
        this.checker = checker;
    }

    @Override
    public boolean check(RequestProcessor processor, Resource model, Object ... parameters) throws DatabaseException {
        CheckRequest request = new CheckRequest(parameters);
        if (processor instanceof ReadGraph) {
            return request.perform((ReadGraph)processor);
        }
        return (Boolean)processor.syncRequest((Read)request);
    }

    @Override
    public Object execute(RequestProcessor processor, Resource model, Object ... parameters) throws DatabaseException {
        if (parameters.length != this.parameterTypes.length) {
            throw new IllegalArgumentException("Wrong number of parameters given (" + parameters.length + ") expected " + this.parameterTypes.length + " parameters.");
        }
        CommitRequest request = new CommitRequest(model, parameters);
        try {
            if (processor instanceof WriteGraph) {
                Object object = request.perform((WriteGraph)processor);
                return object;
            }
            Object object = processor.syncRequest((WriteResult)request);
            return object;
        }
        finally {
            TimeLogger.log((String)("Executed command " + this.name));
        }
    }

    @Override
    public void asyncExecute(RequestProcessor processor, Resource model, Object[] parameters, Procedure<Object> procedure) {
        processor.asyncRequest((WriteResult)new CommitRequest(model, parameters), procedure);
    }

    public static Command create(ReadGraph graph, String name) {
        Object oldGraph = SCLContext.getCurrent().put((Object)"graph", (Object)graph);
        try {
            SCLValue commandRef = SCLOsgi.MODULE_REPOSITORY.getValueRef(name);
            MultiFunction mfun = Types.matchFunction((Type)commandRef.getType());
            Type[] parameterTypes = mfun.parameterTypes;
            Function command = (Function)SCLOsgi.MODULE_REPOSITORY.getValue(name);
            CommandSerializer serializer = CommandSerializerFactory.create(name, parameterTypes);
            Checker checker = Checker.create(String.valueOf(name) + "_check");
            CommandImpl commandImpl = new CommandImpl(name, command, parameterTypes, serializer, checker);
            return commandImpl;
        }
        catch (ValueNotFound e) {
            e.printStackTrace();
            ErrorCommand errorCommand = new ErrorCommand(name);
            return errorCommand;
        }
        finally {
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
    }

    private class CheckRequest
    implements Read<Boolean> {
        Object[] parameters;

        public CheckRequest(Object[] parameters) {
            this.parameters = parameters;
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
            boolean result = CommandImpl.this.checker.check(this.parameters);
            sclContext.put((Object)"graph", oldGraph);
            return result;
        }
    }

    private class CommitRequest
    extends WriteResultRequest<Object> {
        Resource model;
        Object[] parameters;

        public CommitRequest(Resource model, Object[] parameters) {
            this.model = model;
            this.parameters = parameters;
        }

        public Object perform(WriteGraph graph) throws DatabaseException {
            Object oldGraph;
            SCLContext sclContext;
            block5: {
                sclContext = SCLContext.getCurrent();
                oldGraph = sclContext.put((Object)"graph", (Object)graph);
                try {
                    CommandImpl.this.serializer.serialize(graph, this.model, this.parameters);
                }
                catch (Exception e) {
                    if (serializationErrorAlreadySeen) break block5;
                    e.printStackTrace();
                    serializationErrorAlreadySeen = true;
                }
            }
            try {
                Object object = CommandImpl.this.command.applyArray(this.parameters);
                return object;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }
}

