/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import org.simantics.scenegraph.utils.BufferedImage;

public class VRamBufferedImage
extends BufferedImage {
    VolatileImage buffer = null;
    AffineTransform previousTransform = null;

    public VRamBufferedImage(SVGDiagram original, Rectangle2D imageBounds, Point referenceSize) {
        super(original, imageBounds, referenceSize);
    }

    @Override
    public synchronized void releaseRaster() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        float margin = 5.0f;
        if (this.previousTransform == null || this.previousTransform.getScaleX() != g.getTransform().getScaleX() || this.previousTransform.getScaleY() != g.getTransform().getScaleY()) {
            this.buffer = null;
            this.previousTransform = (AffineTransform)g.getTransform().clone();
            int w = (int)((this.imageBounds.getWidth() + (double)(margin * 2.0f)) * this.previousTransform.getScaleX());
            int h = (int)((this.imageBounds.getHeight() + (double)(margin * 2.0f)) * this.previousTransform.getScaleY());
            if (w < 1) {
                w = 1;
            }
            if (h < 1) {
                h = 1;
            }
            this.buffer = g.getDeviceConfiguration().createCompatibleVolatileImage(w, h, 3);
            try {
                Graphics2D b2g = (Graphics2D)this.buffer.getGraphics();
                b2g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                b2g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                b2g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                b2g.setBackground(new Color(255, 255, 255, 0));
                b2g.clearRect(0, 0, w, h);
                b2g.translate(margin, margin);
                b2g.scale(this.previousTransform.getScaleX(), this.previousTransform.getScaleY());
                b2g.translate(-this.imageBounds.getMinX(), -this.imageBounds.getMinY());
                this.source.render(b2g);
            }
            catch (SVGException e) {
                e.printStackTrace();
            }
        }
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        AffineTransform at = (AffineTransform)g.getTransform().clone();
        try {
            g.translate(this.imageBounds.getMinX(), this.imageBounds.getMinY());
            g.scale(1.0 / this.previousTransform.getScaleX(), 1.0 / this.previousTransform.getScaleY());
            g.translate(-margin, -margin);
            g.drawImage(this.buffer, 0, 0, null);
        }
        finally {
            g.setTransform(at);
        }
    }
}

