/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.awt.datatransfer.Transferable;
import java.awt.geom.Point2D;
import org.simantics.scenegraph.g2d.events.Event;

public abstract class MouseEvent
extends Event {
    private static final long serialVersionUID = -2090477028406944454L;
    public static final int LEFT_BUTTON = 1;
    public static final int RIGHT_BUTTON = 2;
    public static final int MIDDLE_BUTTON = 3;
    public static final long CLICK_TIME = 250L;
    public static final int LEFT_MASK = 1;
    public static final int RIGHT_MASK = 2;
    public static final int MIDDLE_MASK = 4;
    public static final int ALL_BUTTONS_MASK = 7;
    public static final int CTRL_MASK = 128;
    public static final int ALT_MASK = 512;
    public static final int ALT_GRAPH_MASK = 8192;
    public static final int SHIFT_MASK = 64;
    public static final int ALL_MODIFIERS_MASK = 8896;
    public final int mouseId;
    public final Point2D controlPosition;
    public final Point2D screenPosition;
    public final int buttons;
    public int stateMask;

    private MouseEvent(Object context, long time, int mouseId, int buttons, int stateMask, Point2D controlPosition, Point2D screenPosition) {
        super(context, time);
        this.mouseId = mouseId;
        this.buttons = buttons;
        this.controlPosition = controlPosition;
        this.screenPosition = screenPosition;
        this.stateMask = stateMask;
    }

    public boolean hasAnyButton(int mask) {
        return (this.buttons & mask) != 0;
    }

    public boolean hasAllButtons(int mask) {
        return (this.buttons & mask) == mask;
    }

    public boolean hasAnyModifier(int mask) {
        return (this.stateMask & mask) != 0;
    }

    public boolean hasAllModifiers(int mask) {
        return (this.stateMask & mask) == mask;
    }

    public boolean isShiftDown() {
        return (this.stateMask & 0x40) != 0;
    }

    public boolean isControlDown() {
        return (this.stateMask & 0x80) != 0;
    }

    public boolean isAltDown() {
        return (this.stateMask & 0x200) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.stateMask & 0x2000) != 0;
    }

    public static int[] getButtonIds(int buttons) {
        int size = 0;
        int i = 0;
        while (i < 32) {
            if ((buttons & 1 << i) != 0) {
                ++size;
            }
            ++i;
        }
        int[] result = new int[size];
        int j = 0;
        int i2 = 0;
        while (i2 < 32) {
            if ((buttons & 1 << i2) != 0) {
                result[j++] = i2 + 1;
            }
            ++i2;
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[mouse#=" + this.mouseId + ", control pos=" + this.controlPosition + ", screen pos=" + this.screenPosition + ", buttons=" + Integer.toBinaryString(this.buttons) + ", stateMask=0x" + Integer.toHexString(this.stateMask) + "]";
    }

    public static abstract class MouseButtonEvent
    extends MouseEvent {
        private static final long serialVersionUID = 3540032494506535841L;
        public final int button;

        public MouseButtonEvent(Object context, long time, int mouseId, int buttons, int stateMask, int button, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, controlPosition, screenPosition);
            this.button = button;
        }
    }

    public static class MouseButtonPressedEvent
    extends MouseButtonEvent {
        private static final long serialVersionUID = -4687294674299429690L;

        public MouseButtonPressedEvent(Object context, long time, int mouseId, int buttons, int stateMask, int button, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, button, controlPosition, screenPosition);
        }
    }

    public static class MouseButtonReleasedEvent
    extends MouseButtonEvent {
        private static final long serialVersionUID = -2303672225339491858L;
        public final long holdTime;

        public MouseButtonReleasedEvent(Object context, long time, int mouseId, int buttons, int stateMask, int button, long holdTime, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, button, controlPosition, screenPosition);
            this.holdTime = holdTime;
        }
    }

    public static class MouseClickEvent
    extends MouseButtonEvent {
        private static final long serialVersionUID = -1737712792090986607L;
        public final int clickCount;

        public MouseClickEvent(Object context, long time, int mouseId, int buttons, int stateMask, int button, int clickCount, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, button, controlPosition, screenPosition);
            this.clickCount = clickCount;
        }
    }

    public static class MouseDoubleClickedEvent
    extends MouseButtonEvent {
        private static final long serialVersionUID = -8046967155607105912L;

        public MouseDoubleClickedEvent(Object context, long time, int mouseId, int buttons, int stateMask, int button, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, button, controlPosition, screenPosition);
        }
    }

    public static class MouseDragBegin
    extends MouseButtonEvent {
        private static final long serialVersionUID = 3882552912240236450L;
        public final Point2D startCanvasPos;
        public final Point2D startControlPos;
        public Transferable transferable = null;

        public MouseDragBegin(Object context, long time, int mouseId, int buttons, int stateMask, int button, Point2D startCanvasPos, Point2D startControlPos, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, button, controlPosition, screenPosition);
            this.startCanvasPos = startCanvasPos;
            this.startControlPos = startControlPos;
        }
    }

    public static class MouseEnterEvent
    extends MouseEvent {
        private static final long serialVersionUID = 6074648747865556588L;

        public MouseEnterEvent(Object context, long time, int mouseId, int buttons, int stateMask, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, controlPosition, screenPosition);
        }
    }

    public static class MouseExitEvent
    extends MouseEvent {
        private static final long serialVersionUID = 8596801599996844789L;

        public MouseExitEvent(Object context, long time, int mouseId, int buttons, int stateMask, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, controlPosition, screenPosition);
        }
    }

    public static class MouseMovedEvent
    extends MouseEvent {
        private static final long serialVersionUID = 1463958776335678155L;

        public MouseMovedEvent(Object context, long time, int mouseId, int buttons, int stateMask, Point2D controlPosition, Point2D screenPosition) {
            super(context, time, mouseId, buttons, stateMask, controlPosition, screenPosition);
        }
    }

    public static class MouseWheelMovedEvent
    extends MouseEvent {
        private static final long serialVersionUID = -7896477913481842708L;
        public static final int SCROLL_AMOUNT_ZERO = 0;
        public static final int WHEEL_UNIT_SCROLL = 0;
        public static final int WHEEL_BLOCK_SCROLL = 1;
        public final int scrollType;
        public final int scrollAmount;
        public final int wheelRotation;

        public MouseWheelMovedEvent(Object context, long time, int mouseId, int buttons, int stateMask, Point2D controlPosition, Point2D screenPosition, int scrollType, int scrollAmount, int wheelRotation) {
            super(context, time, mouseId, buttons, stateMask, controlPosition, screenPosition);
            this.scrollType = scrollType;
            this.scrollAmount = scrollAmount;
            this.wheelRotation = wheelRotation;
        }
    }
}

