package org.simantics.scenegraph.swing;

import java.awt.Point;

import javax.swing.JComponent;
import javax.swing.JViewport;

import org.simantics.scenegraph.INode;

public class JViewportSG extends JViewport implements JComponentSG {

	private static final long serialVersionUID = 1941565557888406721L;

	final private INode node;
	
	public JViewportSG(INode node) {
		super();
		this.node = node;
	}

	@Override
	public boolean contains(int eventX, int eventY) {
		return JComponentUtils.contains(eventX, eventY, this, node);
	}
	
	@Override
	public boolean containsTransformed(Point p) {
		return super.contains(p.x, p.y);
	}
	
	@Override
	public JComponent getComponent() {
		return this;
	}
	
}
